/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.impl.NumericCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

public class FloatCondition
extends NumericCondition<Float> {
    public FloatCondition(DslField field) {
        super(field);
    }

    public FloatCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<Float>> value) {
        super(field, metadata, value);
    }

    @Override
    NumericCondition<Float> numericCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<Float>> value) {
        return new FloatCondition(field, metadata, value);
    }

    @Override
    public BiFunction<Float, Float, Boolean> lesserThanFunction() {
        return (l, r) -> l.floatValue() < r.floatValue();
    }

    @Override
    public BiFunction<Float, Float, Boolean> lesserOrEqualsFunction() {
        return (l, r) -> l.floatValue() <= r.floatValue();
    }

    @Override
    public BiFunction<Float, Float, Boolean> greaterThanFunction() {
        return (l, r) -> l.floatValue() > r.floatValue();
    }

    @Override
    public BiFunction<Float, Float, Boolean> greaterOrEqualsFunction() {
        return (l, r) -> l.floatValue() >= r.floatValue();
    }

    @Override
    BinaryOperator<Float> minFunction() {
        return Float::min;
    }

    @Override
    BinaryOperator<Float> sumFunction() {
        return Float::sum;
    }

    @Override
    BiFunction<Float, Integer, Float> timesFunction() {
        return (l, r) -> Float.valueOf(l.floatValue() * (float)r.intValue());
    }

    @Override
    Float identity() {
        return Float.valueOf(0.0f);
    }
}

