/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.impl.DefaultContext;
import io.doov.core.dsl.impl.DefaultResult;
import io.doov.core.dsl.lang.Result;
import io.doov.core.dsl.lang.RuleRegistry;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.Locale;

public class DefaultValidationRule
implements ValidationRule {
    private final StepWhen stepWhen;
    private final String message;
    private final boolean shortCircuit;

    protected DefaultValidationRule(StepWhen stepWhen) {
        this(stepWhen, null, true);
    }

    protected DefaultValidationRule(StepWhen stepWhen, String message) {
        this(stepWhen, message, true);
    }

    public DefaultValidationRule(StepWhen stepWhen, String message, boolean shortCircuit) {
        this.stepWhen = stepWhen;
        this.message = message;
        this.shortCircuit = shortCircuit;
    }

    protected boolean isShortCircuit() {
        return this.shortCircuit;
    }

    protected StepWhen getStepWhen() {
        return this.stepWhen;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ValidationRule withMessage(String message) {
        return new DefaultValidationRule(this.stepWhen, message);
    }

    @Override
    public ValidationRule withShortCircuit(boolean shortCircuit) {
        return new DefaultValidationRule(this.stepWhen, this.message, shortCircuit);
    }

    @Override
    public Result executeOn(DslModel model) {
        DefaultContext context = new DefaultContext(this.shortCircuit, this.stepWhen.stepCondition().getMetadata());
        boolean valid = this.stepWhen.stepCondition().predicate().test(model, context);
        String readable = valid ? null : (this.message == null ? this.stepWhen.stepCondition().readable() : this.message);
        return new DefaultResult(valid, readable, context);
    }

    @Override
    public ValidationRule registerOn(RuleRegistry registry) {
        registry.register(this);
        return this;
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this, Locale.getDefault());
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.start(this, depth);
        this.stepWhen.accept(visitor, depth);
        visitor.visit(this, depth);
        visitor.end(this, depth);
    }

    @Override
    public Metadata getRootMetadata() {
        if (this.stepWhen == null) {
            return null;
        }
        if (this.stepWhen.stepCondition() == null) {
            return null;
        }
        return this.stepWhen.stepCondition().getMetadata();
    }
}

