/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslId;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.PredicateMetadata;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.Locale;
import java.util.function.BiPredicate;

abstract class AbstractStepCondition
implements StepCondition {
    private final PredicateMetadata metadata;
    private final BiPredicate<DslModel, Context> predicate;

    protected AbstractStepCondition(PredicateMetadata metadata, BiPredicate<DslModel, Context> predicate) {
        this.metadata = metadata;
        this.predicate = predicate;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public BiPredicate<DslModel, Context> predicate() {
        return (model, context) -> {
            boolean test = this.predicate.test(new Interceptor((DslModel)model, (Context)context), (Context)context);
            if (test) {
                this.metadata.incTrueEval();
                context.addEvalTrue(this.metadata);
            } else {
                this.metadata.incFalseEval();
                context.addEvalFalse(this.metadata);
            }
            return test;
        };
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this, Locale.getDefault());
    }

    @Override
    public void accept(MetadataVisitor visitor, int depth) {
        visitor.visit(this, depth);
        this.metadata.accept(visitor, depth);
    }

    private static final class Interceptor
    implements DslModel {
        private final DslModel model;
        private final Context context;

        Interceptor(DslModel model, Context context) {
            this.model = model;
            this.context = context;
        }

        @Override
        public <T> T get(DslId id) {
            Object value = this.model.get(id);
            this.context.addEvalValue(id, value);
            return value;
        }
    }
}

