/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.field;

import io.doov.core.FieldId;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslId;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.field.DefaultFieldInfo;
import io.doov.core.dsl.field.TemporalFieldInfo;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.impl.LocalTimeCondition;
import io.doov.core.dsl.impl.TemporalCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.BiFunction;

public class TimeIsoFieldInfo
extends DefaultFieldInfo<LocalTime>
implements TemporalFieldInfo<LocalTime> {
    TimeIsoFieldInfo(FieldId fieldId, String readable, FieldId ... siblings) {
        super(fieldId, readable, String.class, new Class[0], siblings);
    }

    @Override
    public DefaultCondition<LocalTime> getDefaultCondition() {
        return new TimeIsoCondition(this);
    }

    @Override
    public TemporalCondition<LocalTime> getTemporalCondition() {
        return new TimeIsoCondition(this);
    }

    public static Optional<LocalTime> parse(DslModel model, DslId id) {
        return Optional.ofNullable(model.get(id)).map(v -> LocalTime.parse(v, DateTimeFormatter.BASIC_ISO_DATE));
    }

    private class TimeIsoCondition
    extends LocalTimeCondition {
        private TimeIsoCondition(DslField field) {
            super(field);
        }

        private TimeIsoCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<LocalTime>> value) {
            super(field, metadata, value);
        }

        @Override
        protected TemporalCondition<LocalTime> temporalCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<LocalTime>> value) {
            return new TimeIsoCondition(field, metadata, value);
        }

        @Override
        protected Optional<LocalTime> valueModel(DslModel model, DslField field) {
            return TimeIsoFieldInfo.parse(model, field.id());
        }
    }
}

