/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.field;

import io.doov.core.FieldId;
import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslId;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.field.DefaultFieldInfo;
import io.doov.core.dsl.field.TemporalFieldInfo;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.impl.LocalDateCondition;
import io.doov.core.dsl.impl.TemporalCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.meta.PredicateMetadata;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.BiFunction;

public class DateIsoFieldInfo
extends DefaultFieldInfo<LocalDate>
implements TemporalFieldInfo<LocalDate> {
    DateIsoFieldInfo(FieldId fieldId, String readable, FieldId ... siblings) {
        super(fieldId, readable, String.class, new Class[0], siblings);
    }

    @Override
    public DefaultCondition<LocalDate> getDefaultCondition() {
        return new DateIsoCondition(this);
    }

    @Override
    public TemporalCondition<LocalDate> getTemporalCondition() {
        return new DateIsoCondition(this);
    }

    public static Optional<LocalDate> parse(DslModel model, DslId id) {
        return Optional.ofNullable(model.get(id)).map(v -> LocalDate.parse(v, DateTimeFormatter.BASIC_ISO_DATE));
    }

    private class DateIsoCondition
    extends LocalDateCondition {
        private DateIsoCondition(DslField field) {
            super(field);
        }

        private DateIsoCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<LocalDate>> value) {
            super(field, metadata, value);
        }

        @Override
        protected TemporalCondition<LocalDate> temporalCondition(DslField field, PredicateMetadata metadata, BiFunction<DslModel, Context, Optional<LocalDate>> value) {
            return new DateIsoCondition(field, metadata, value);
        }

        @Override
        protected Optional<LocalDate> valueModel(DslModel model, DslField field) {
            return DateIsoFieldInfo.parse(model, field.id());
        }
    }
}

