/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl;

import io.doov.core.dsl.field.NumericFieldInfo;
import io.doov.core.dsl.impl.DefaultStepCondition;
import io.doov.core.dsl.impl.DefaultStepWhen;
import io.doov.core.dsl.impl.IntegerCondition;
import io.doov.core.dsl.impl.LogicalNaryCondition;
import io.doov.core.dsl.impl.NumericCondition;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.meta.LeafMetadata;
import java.util.Arrays;
import java.util.Objects;

public class DOOV {
    private DOOV() {
    }

    public static StepWhen when(StepCondition condition) {
        return new DefaultStepWhen(condition);
    }

    public static StepCondition alwaysTrue() {
        return new DefaultStepCondition(LeafMetadata.trueMetadata(), (model, context) -> true);
    }

    public static StepCondition alwaysFalse() {
        return new DefaultStepCondition(LeafMetadata.falseMetadata(), (model, context) -> false);
    }

    public static IntegerCondition count(StepCondition ... steps) {
        return LogicalNaryCondition.count(Arrays.asList(steps));
    }

    public static StepCondition matchAny(StepCondition ... steps) {
        return LogicalNaryCondition.matchAny(Arrays.asList(steps));
    }

    public static StepCondition matchAll(StepCondition ... steps) {
        return LogicalNaryCondition.matchAll(Arrays.asList(steps));
    }

    public static StepCondition matchNone(StepCondition ... steps) {
        return LogicalNaryCondition.matchNone(Arrays.asList(steps));
    }

    @SafeVarargs
    public static <N extends Number> NumericCondition<N> min(NumericFieldInfo<N> ... fields) {
        return Arrays.stream(fields).filter(Objects::nonNull).findFirst().map(NumericFieldInfo::getNumericCondition).map(c -> c.min(Arrays.asList(fields))).orElseThrow(IllegalArgumentException::new);
    }

    @SafeVarargs
    public static <N extends Number> NumericCondition<N> sum(NumericFieldInfo<N> ... fields) {
        return Arrays.stream(fields).filter(Objects::nonNull).findFirst().map(NumericFieldInfo::getNumericCondition).map(c -> c.sum(Arrays.asList(fields))).orElseThrow(IllegalArgumentException::new);
    }

    @SafeVarargs
    public static <N extends Number> NumericCondition<N> sum(NumericCondition<N> ... conditions) {
        return Arrays.stream(conditions).filter(Objects::nonNull).findFirst().map(c -> c.sumConditions(Arrays.asList(conditions))).orElseThrow(IllegalArgumentException::new);
    }
}

