/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core;

import io.doov.core.FieldId;
import io.doov.core.FieldInfo;
import io.doov.core.TagId;
import io.doov.core.dsl.DslId;
import io.doov.core.dsl.DslModel;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface FieldModel
extends Iterable<Map.Entry<FieldId, Object>>,
DslModel {
    @Override
    public <T> T get(DslId var1);

    public <T> void set(FieldId var1, T var2);

    public Stream<Map.Entry<FieldId, Object>> stream();

    @Override
    public Spliterator<Map.Entry<FieldId, Object>> spliterator();

    public Stream<Map.Entry<FieldId, Object>> parallelStream();

    public List<FieldInfo> getFieldInfos();

    default public List<FieldId> getFieldIds() {
        return this.getFieldInfos().stream().map(FieldInfo::id).collect(Collectors.toList());
    }

    default public void setAll(FieldModel source) {
        this.getFieldInfos().stream().filter(info -> source.get(info.id()) != null).forEach(info -> this.set(info.id(), source.get(info.id())));
    }

    default public void clear() {
        this.getFieldInfos().stream().filter(info -> this.get(info.id()) != null).forEach(info -> this.set(info.id(), null));
    }

    default public void clear(TagId tag) {
        this.getFieldInfos().stream().filter(info -> info.id().hasTag(tag) && this.get(info.id()) != null).forEach(info -> this.set(info.id(), null));
    }

    default public FieldInfo info(FieldId id) {
        return this.getFieldInfos().stream().filter(info -> info.id() == id).findFirst().orElse(null);
    }
}

