/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.time;

import io.doov.core.dsl.impl.LocalDateCondition;
import io.doov.core.dsl.impl.TemporalCondition;
import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.Metadata;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.Optional;

public class LocalDateSuppliers {
    private LocalDateSuppliers() {
    }

    public static TemporalCondition<LocalDate> today() {
        return new LocalDateCondition(null, (Metadata)FieldMetadata.todayMetadata(), (model, context) -> Optional.of(LocalDate.now()));
    }

    public static TemporalCondition<LocalDate> todayPlus(int amountToAdd, TemporalUnit unit) {
        return new LocalDateCondition(null, (Metadata)FieldMetadata.todayPlusMetadata(amountToAdd, unit), (model, context) -> Optional.of(LocalDate.now().plus(amountToAdd, unit)));
    }

    public static TemporalCondition<LocalDate> todayPlusDays(int daysToAdd) {
        return LocalDateSuppliers.todayPlus(daysToAdd, ChronoUnit.DAYS);
    }

    public static TemporalCondition<LocalDate> todayPlusYears(int yearsToAdd) {
        return LocalDateSuppliers.todayPlus(yearsToAdd, ChronoUnit.YEARS);
    }

    public static TemporalCondition<LocalDate> todayMinus(int amountToSubstract, TemporalUnit unit) {
        return new LocalDateCondition(null, (Metadata)FieldMetadata.todayMinusMetadata(amountToSubstract, unit), (model, context) -> Optional.of(LocalDate.now().minus(amountToSubstract, unit)));
    }

    public static TemporalCondition<LocalDate> todayMinusDays(int daysToSubstract) {
        return LocalDateSuppliers.todayMinus(daysToSubstract, ChronoUnit.DAYS);
    }

    public static TemporalCondition<LocalDate> todayMinusYears(int yearsToSubstract) {
        return LocalDateSuppliers.todayMinus(yearsToSubstract, ChronoUnit.YEARS);
    }

    public static TemporalCondition<LocalDate> firstDayOfThisMonth() {
        return new LocalDateCondition(null, (Metadata)FieldMetadata.firstDayOfThisMonthMetadata(), (model, context) -> Optional.of(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth())));
    }

    public static TemporalCondition<LocalDate> firstDayOfThisYear() {
        return new LocalDateCondition(null, (Metadata)FieldMetadata.firstDayOfThisYearMetadata(), (model, context) -> Optional.of(LocalDate.now().with(TemporalAdjusters.firstDayOfYear())));
    }

    public static TemporalCondition<LocalDate> lastDayOfThisMonth() {
        return new LocalDateCondition(null, (Metadata)FieldMetadata.lastDayOfThisMonthMetadata(), (model, context) -> Optional.of(LocalDate.now().with(TemporalAdjusters.lastDayOfMonth())));
    }

    public static TemporalCondition<LocalDate> lastDayOfThisYear() {
        return new LocalDateCondition(null, (Metadata)FieldMetadata.lastDayOfThisYearMetadata(), (model, context) -> Optional.of(LocalDate.now().with(TemporalAdjusters.lastDayOfYear())));
    }

    public static TemporalCondition<LocalDate> date(int year, int month, int dayOfMonth) {
        return new LocalDateCondition(null, (Metadata)FieldMetadata.dateMetadata(LocalDate.of(year, month, dayOfMonth)), (model, context) -> Optional.of(LocalDate.of(year, month, dayOfMonth)));
    }
}

