/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.UnaryMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;
import java.util.stream.Collectors;

public class AstTextVisitor
extends AbstractAstVisitor {
    private static final int INDENT_SIZE = 2;

    public AstTextVisitor(StringBuilder stringBuilder) {
        super(stringBuilder);
    }

    @Override
    public void visitMetadata(FieldMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatFieldMetadata(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(UnaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatOperator(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(BinaryMetadata metadata) {
        this.sb.delete(this.getNewLineIndex(), this.sb.length());
        this.sb.append(" ");
        this.sb.append(this.formatOperator(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMetadata(NaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatOperator(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMetadata(ValidationRule metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatRule());
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(ValidationRule metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatValidateWithMessage());
        this.sb.append(" ");
        this.sb.append(this.formatMessage(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMetadata(StepWhen metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(this.formatWhen());
        this.sb.append(this.formatNewLine());
    }

    @Override
    protected int getIndentSize() {
        return 2;
    }

    @Override
    protected int getCurrentIndentSize() {
        if (AbstractAstVisitor.Element.BINARY.equals((Object)this.stackPeek())) {
            return (int)this.stackSteam().filter(e -> !AbstractAstVisitor.Element.BINARY.equals(e)).count() * this.getIndentSize();
        }
        return super.getCurrentIndentSize();
    }

    protected String formatFieldMetadata(FieldMetadata metadata) {
        return metadata.stream().map(FieldMetadata.Element::getReadable).map(Readable::readable).collect(Collectors.joining(" "));
    }

    protected String formatField(Readable field) {
        return field == null ? null : field.readable();
    }

    protected String formatOperator(Readable operator) {
        return operator == null ? null : operator.readable();
    }

    protected String formatValue(Readable value) {
        return value == null ? null : value.readable();
    }

    protected String formatOperator(UnaryMetadata metadata) {
        return metadata.getOperator();
    }

    protected String formatOperator(BinaryMetadata metadata) {
        return metadata.getOperator();
    }

    protected String formatOperator(NaryMetadata metadata) {
        return metadata.getOperator();
    }

    protected String formatRule() {
        return "Rule";
    }

    protected String formatValidateWithMessage() {
        return "validate with message";
    }

    protected String formatMessage(ValidationRule metadata) {
        String message = metadata.getMessage() == null ? "empty" : metadata.getMessage();
        return "'" + message + "'";
    }

    protected String formatWhen() {
        return "when";
    }
}

