/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.ast.AstTextVisitor;

public class AstLineVisitor
extends AstTextVisitor {
    public AstLineVisitor(StringBuilder stringBuilder) {
        super(stringBuilder);
    }

    @Override
    protected String formatCurrentIndent() {
        return "";
    }

    @Override
    protected String formatNewLine() {
        return " ";
    }

    @Override
    public void startMetadata(NaryMetadata metadata) {
        super.startMetadata(metadata);
        this.sb.append("[");
    }

    @Override
    public void visitMetadata(NaryMetadata metadata) {
        super.visitMetadata(metadata);
        this.sb.delete(this.sb.length() - 1, this.sb.length());
        this.sb.append(", ");
    }

    @Override
    protected void endMetadata(NaryMetadata metadata) {
        super.endMetadata(metadata);
        this.sb.delete(this.sb.length() - 2, this.sb.length());
        this.sb.append("] ");
    }

    @Override
    protected void startMetadata(BinaryMetadata metadata) {
        super.startMetadata(metadata);
        this.sb.append("(");
    }

    @Override
    public void visitMetadata(BinaryMetadata metadata) {
        this.sb.append(this.formatOperator(metadata));
        this.sb.append(this.formatNewLine());
    }

    @Override
    protected void endMetadata(BinaryMetadata metadata) {
        super.endMetadata(metadata);
        this.sb.delete(this.sb.length() - 1, this.sb.length());
        this.sb.append(") ");
    }

    @Override
    protected void endMetadata(ValidationRule metadata) {
        super.endMetadata(metadata);
        this.sb.append("\n");
    }
}

