/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.UnaryMetadata;
import io.doov.core.dsl.meta.ast.AstTextVisitor;
import java.text.MessageFormat;

public class AstHtmlVisitor
extends AstTextVisitor {
    private static final String CSS_CLASS_VALIDATION_MESSAGE = "dsl-validation-message";
    private static final String CSS_CLASS_VALIDATION_RULE = "dsl-validation-rule";
    private static final String CSS_CLASS_VALIDATE = "dsl-token-validate";
    private static final String CSS_CLASS_BINARY = "dsl-token-binary";
    private static final String CSS_CLASS_UNARY = "dsl-token-unary";
    private static final String CSS_CLASS_NARY = "dsl-token-nary";
    private static final String CSS_CLASS_RULE = "dsl-token-rule";
    private static final String CSS_CLASS_WHEN = "dsl-token-when";
    private static final String END_DIV = "</div>";
    private static final String BEG_LI = "<li>";
    private static final String END_LI = "</li>";
    private static final String BEG_OL = "<ol>";
    private static final String END_OL = "</ol>";
    private static final String BEG_UL = "<ul>";
    private static final String END_UL = "</ul>";
    private int binaryDeep = 0;
    private boolean closeFieldLI;

    public AstHtmlVisitor(StringBuilder stringBuilder) {
        super(stringBuilder);
    }

    @Override
    public void startMetadata(StepWhen metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(BEG_UL);
        this.sb.append(this.formatNewLine());
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(BEG_LI);
    }

    @Override
    public void visitMetadata(StepWhen metadata) {
        this.HtmlFormatSpan(CSS_CLASS_WHEN, this.formatWhen(), this.sb);
        this.sb.append(END_LI);
        this.sb.append(this.formatNewLine());
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(BEG_UL);
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void endMetadata(StepWhen metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(END_UL);
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMetadata(FieldMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        String[] split = this.sb.toString().split("\n");
        if (!split[split.length - 2].contains(">and<") && !split[split.length - 2].contains(">or<")) {
            this.sb.append(BEG_LI);
            this.closeFieldLI = true;
        }
    }

    @Override
    public void visitMetadata(FieldMetadata metadata) {
        this.formatFieldClass(metadata, this.sb);
    }

    @Override
    public void endMetadata(FieldMetadata metadata) {
        if (this.closeFieldLI) {
            this.sb.append(END_LI);
            this.closeFieldLI = false;
        }
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void startMetadata(BinaryMetadata metadata) {
        String[] split = this.sb.toString().split("\n");
        if (split[split.length - 1].contains(">and<") || split[split.length - 1].contains(">or<")) {
            this.sb.append(this.formatCurrentIndent());
            this.sb.append(BEG_UL);
            this.sb.append(this.formatNewLine());
            ++this.binaryDeep;
        }
    }

    @Override
    public void visitMetadata(BinaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.HtmlFormatSpan(CSS_CLASS_BINARY, metadata.getOperator(), this.sb);
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void endMetadata(BinaryMetadata metadata) {
        if (this.binaryDeep > 0) {
            this.sb.append(this.formatNewLine());
            this.sb.append(this.formatCurrentIndent());
            this.sb.append(END_UL);
            --this.binaryDeep;
        }
    }

    @Override
    public void startMetadata(NaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(BEG_LI);
        this.sb.append(this.formatNewLine());
        this.sb.append(this.formatCurrentIndent());
        this.HtmlFormatSpan(CSS_CLASS_NARY, metadata.getOperator(), this.sb);
        this.sb.append(BEG_OL);
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void endMetadata(NaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(END_OL);
        this.sb.append(this.formatNewLine());
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(END_LI);
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(UnaryMetadata metadata) {
        this.sb.append(BEG_LI);
        this.HtmlFormatSpan(CSS_CLASS_UNARY, metadata.getOperator(), this.sb);
        this.sb.append(END_LI);
        this.sb.append(BEG_UL);
    }

    @Override
    public void startMetadata(ValidationRule metadata) {
        this.formatDivStart(CSS_CLASS_VALIDATION_RULE, this.sb);
        this.sb.append(this.formatNewLine());
        this.sb.append(BEG_UL);
        this.sb.append(this.formatNewLine());
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(BEG_LI);
        this.HtmlFormatSpan(CSS_CLASS_RULE, this.formatRule(), this.sb);
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(ValidationRule metadata) {
        this.sb.append(BEG_LI);
        this.HtmlFormatSpan(CSS_CLASS_VALIDATE, this.formatValidateWithMessage(), this.sb);
        this.sb.append(" ");
        this.HtmlFormatSpan(CSS_CLASS_VALIDATION_MESSAGE, this.formatMessage(metadata), this.sb);
        this.sb.append(END_LI);
        this.sb.append(END_UL);
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void endMetadata(ValidationRule metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append(END_UL);
        this.sb.append(this.formatNewLine());
        this.sb.append(END_DIV);
        this.sb.append(this.formatNewLine());
    }

    @Override
    public void visitMetadata(Metadata metadata) {
        this.sb.append(this.formatOperator(metadata));
    }

    @Override
    protected String formatWhen() {
        return "When";
    }

    @Override
    protected String formatMessage(ValidationRule metadata) {
        return MessageFormat.format("\"{0}\"", metadata.getMessage() == null ? "empty" : metadata.getMessage());
    }

    private void formatFieldClass(FieldMetadata field, StringBuilder sb) {
        field.stream().forEach(element -> this.HtmlFormatSpan(this.getCssClass((FieldMetadata.Element)element), element.getReadable().readable(), sb));
    }

    private String getCssClass(FieldMetadata.Element element) {
        switch (element.getType()) {
            case field: {
                return "dsl-token-field";
            }
            case operator: {
                return "dsl-token-operator";
            }
            case value: {
                return "dsl-token-value";
            }
            case unknown: {
                return "dsl-token-unknown";
            }
        }
        throw new IllegalArgumentException("Unknown css class for element " + element);
    }

    private void HtmlFormatSpan(String cssClass, String content, StringBuilder sb) {
        sb.append("<span class=\"").append(cssClass).append("\">");
        sb.append(content).append("</span>");
    }

    private void formatDivStart(String cssClass, StringBuilder sb) {
        sb.append("<div class=\"").append(cssClass).append("\">");
    }
}

