/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.UnaryMetadata;
import io.doov.core.dsl.meta.ast.AbstractAstVisitor;

public class AstFullVisitor
extends AbstractAstVisitor {
    private static final int INDENT_SIZE = 4;

    public AstFullVisitor(StringBuilder stringBuilder) {
        super(stringBuilder);
    }

    @Override
    public void visitMetadata(Metadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit Metadata ").append(metadata);
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(FieldMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit FieldMetadata ").append(metadata).append(" = ");
        metadata.stream().map(FieldMetadata.Element::getReadable).forEach(this.sb::append);
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(UnaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit UnaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void startMetadata(BinaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start BinaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(BinaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit BinaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void endMetadata(BinaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end BinaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void startMetadata(NaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start NaryMetadata ").append(metadata).append(" = ").append(metadata.getOperator());
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(NaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit NaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void endMetadata(NaryMetadata metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end NaryMetadata ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void startMetadata(ValidationRule metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start ValidationRule ").append(metadata).append(" = ").append("rule");
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(ValidationRule metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit ValidationRule ").append(metadata).append(" = ").append("validate with message");
        this.sb.append("\n");
    }

    @Override
    public void endMetadata(ValidationRule metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end ValidationRule ").append(metadata).append(" = ").append(metadata.getMessage());
        this.sb.append("\n");
    }

    @Override
    public void startMetadata(StepWhen metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("start StepWhen ").append(metadata).append(" = ").append("when");
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(StepWhen metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit StepWhen ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void endMetadata(StepWhen metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("end StepWhen ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    public void visitMetadata(StepCondition metadata) {
        this.sb.append(this.formatCurrentIndent());
        this.sb.append("visit StepCondition ").append(metadata).append(" = ").append("---");
        this.sb.append("\n");
    }

    @Override
    protected int getIndentSize() {
        return 4;
    }
}

