/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta.ast;

import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.lang.StepWhen;
import io.doov.core.dsl.lang.ValidationRule;
import io.doov.core.dsl.meta.BinaryMetadata;
import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.NaryMetadata;
import io.doov.core.dsl.meta.UnaryMetadata;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractAstVisitor
implements MetadataVisitor {
    private final Deque<Element> stack = new ArrayDeque<Element>();
    private int newLineIndex = 0;
    final StringBuilder sb;

    public AbstractAstVisitor(StringBuilder stringBuilder) {
        this.sb = stringBuilder;
    }

    @Override
    public final void visit(Metadata metadata) {
        this.visitMetadata(metadata);
    }

    protected void visitMetadata(Metadata metadata) {
    }

    @Override
    public final void start(FieldMetadata metadata) {
        this.startMetadata(metadata);
    }

    protected void startMetadata(FieldMetadata metadata) {
    }

    @Override
    public final void visit(FieldMetadata metadata) {
        this.visitMetadata(metadata);
    }

    protected void visitMetadata(FieldMetadata metadata) {
    }

    @Override
    public final void end(FieldMetadata metadata) {
        this.endMetadata(metadata);
    }

    protected void endMetadata(FieldMetadata metadata) {
    }

    @Override
    public final void visit(UnaryMetadata metadata) {
        this.visitMetadata(metadata);
    }

    protected void visitMetadata(UnaryMetadata metadata) {
    }

    @Override
    public final void start(BinaryMetadata metadata) {
        this.startMetadata(metadata);
        this.stack.push(Element.BINARY);
    }

    protected void startMetadata(BinaryMetadata metadata) {
    }

    @Override
    public final void visit(BinaryMetadata metadata) {
        this.visitMetadata(metadata);
    }

    protected void visitMetadata(BinaryMetadata metadata) {
    }

    @Override
    public final void end(BinaryMetadata metadata) {
        this.stack.pop();
        this.endMetadata(metadata);
    }

    protected void endMetadata(BinaryMetadata metadata) {
    }

    @Override
    public final void start(NaryMetadata metadata) {
        this.startMetadata(metadata);
        this.stack.push(Element.NARY);
    }

    protected void startMetadata(NaryMetadata metadata) {
    }

    @Override
    public final void visit(NaryMetadata metadata) {
        this.visitMetadata(metadata);
    }

    protected void visitMetadata(NaryMetadata metadata) {
    }

    @Override
    public final void end(NaryMetadata metadata) {
        this.stack.pop();
        this.endMetadata(metadata);
    }

    protected void endMetadata(NaryMetadata metadata) {
    }

    @Override
    public final void start(ValidationRule metadata) {
        this.startMetadata(metadata);
        this.stack.push(Element.RULE);
    }

    protected void startMetadata(ValidationRule metadata) {
    }

    @Override
    public final void visit(ValidationRule metadata) {
        this.visitMetadata(metadata);
    }

    protected void visitMetadata(ValidationRule metadata) {
    }

    @Override
    public final void end(ValidationRule metadata) {
        this.stack.pop();
        this.endMetadata(metadata);
    }

    protected void endMetadata(ValidationRule metadata) {
    }

    @Override
    public final void start(StepWhen metadata) {
        this.startMetadata(metadata);
        this.stack.push(Element.WHEN);
    }

    protected void startMetadata(StepWhen metadata) {
    }

    @Override
    public final void visit(StepWhen metadata) {
        this.visitMetadata(metadata);
    }

    protected void visitMetadata(StepWhen metadata) {
    }

    @Override
    public final void end(StepWhen metadata) {
        this.stack.pop();
        this.endMetadata(metadata);
    }

    protected void endMetadata(StepWhen metadata) {
    }

    @Override
    public final void visit(StepCondition metadata) {
        this.visitMetadata(metadata);
    }

    protected void visitMetadata(StepCondition metadata) {
    }

    protected int getIndentSize() {
        return 0;
    }

    protected int getNewLineIndex() {
        return this.newLineIndex;
    }

    protected int getCurrentIndentSize() {
        return this.stack.size() * this.getIndentSize();
    }

    protected String formatCurrentIndent() {
        return IntStream.range(0, this.getCurrentIndentSize()).mapToObj(i -> " ").collect(Collectors.joining(""));
    }

    protected String formatNewLine() {
        this.newLineIndex = this.sb.length();
        return "\n";
    }

    protected final Element stackPeek() {
        return this.stack.peek();
    }

    protected final Stream<Element> stackSteam() {
        return this.stack.stream();
    }

    static enum Element {
        RULE,
        WHEN,
        UNARY,
        BINARY,
        NARY;

    }
}

