/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.List;

public class NaryMetadata
implements Metadata {
    private final String operator;
    private final List<Metadata> values;

    private NaryMetadata(String operator, List<Metadata> values) {
        this.operator = operator;
        this.values = values;
    }

    public String getOperator() {
        return this.operator;
    }

    public static NaryMetadata matchAnyMetadata(List<Metadata> values) {
        return new NaryMetadata("match any", values);
    }

    public static NaryMetadata matchAllMetadata(List<Metadata> values) {
        return new NaryMetadata("match all", values);
    }

    public static NaryMetadata matchNoneMetadata(List<Metadata> values) {
        return new NaryMetadata("match none", values);
    }

    public static NaryMetadata countMetadata(List<Metadata> values) {
        return new NaryMetadata("count", values);
    }

    public static NaryMetadata sumMetadata(List<Metadata> values) {
        return new NaryMetadata("sum", values);
    }

    public static NaryMetadata minMetadata(List<Metadata> values) {
        return new NaryMetadata("min", values);
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.start(this);
        this.values.forEach(v -> {
            v.accept(visitor);
            visitor.visit(this);
        });
        visitor.end(this);
    }

    @Override
    public Metadata merge(FieldMetadata other) {
        return new NaryMetadata(this.operator + " " + other.readable(), this.values);
    }
}

