/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldMetadata
implements Metadata {
    private static final Collector<CharSequence, ?, String> COLLECTOR_LIST = Collectors.joining(", ", " : ", "");
    private final Deque<Element> elements;

    public FieldMetadata() {
        this.elements = new LinkedList<Element>();
    }

    public FieldMetadata(FieldMetadata metadata) {
        this.elements = new LinkedList<Element>(metadata.elements);
    }

    public Stream<Element> stream() {
        return this.elements.stream();
    }

    protected FieldMetadata elements(FieldMetadata readable) {
        if (readable != null) {
            this.elements.addAll(readable.elements);
        }
        return this;
    }

    private FieldMetadata add(Element element) {
        if (element != null) {
            this.elements.add(element);
        }
        return this;
    }

    public FieldMetadata field(Readable readable) {
        return this.add(readable == null ? null : new Element(readable, Type.field));
    }

    public FieldMetadata operator(Readable readable) {
        return this.add(readable == null ? null : new Element(readable, Type.operator));
    }

    public FieldMetadata operator(String readable) {
        return this.add(readable == null ? null : new Element(() -> readable, Type.operator));
    }

    public FieldMetadata valueObject(Object readable) {
        return this.add(readable == null ? null : new Element(() -> String.valueOf(readable), Type.value));
    }

    public FieldMetadata valueString(String readable) {
        return this.add(readable == null ? null : new Element(() -> readable, Type.value));
    }

    public FieldMetadata valueReadable(Readable readable) {
        return this.add(readable == null ? null : new Element(readable, Type.value));
    }

    public FieldMetadata valueSupplier(Supplier<?> readable) {
        return this.add(readable == null ? null : new Element(() -> String.valueOf(readable.get()), Type.value));
    }

    public FieldMetadata valueUnknown(String readable) {
        return this.add(readable == null ? null : new Element(() -> "UNKNOWN " + readable, Type.unknown));
    }

    public FieldMetadata valueListReadable(Collection<? extends Readable> readables) {
        return this.add(readables == null || readables.isEmpty() ? null : new Element(() -> FieldMetadata.formatListReadable(readables), Type.value));
    }

    public FieldMetadata valueListObject(Collection<?> readables) {
        return this.add(readables == null || readables.isEmpty() ? null : new Element(() -> FieldMetadata.formatListObject(readables), Type.value));
    }

    @Override
    public Metadata merge(FieldMetadata other) {
        this.removeDuplicateField(other);
        FieldMetadata fieldMetadata = new FieldMetadata(this);
        fieldMetadata.elements.addAll(other.elements);
        return fieldMetadata;
    }

    private void removeDuplicateField(FieldMetadata other) {
        if (this.elements.isEmpty() || other.elements.isEmpty()) {
            return;
        }
        if (this.elements.peek().type.equals((Object)Type.field) && other.elements.peek().type.equals((Object)Type.field)) {
            other.elements.pop();
        }
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.start(this);
        visitor.visit(this);
        visitor.end(this);
    }

    public static FieldMetadata fieldMetadata(Readable field) {
        return new FieldMetadata().field(field);
    }

    public static FieldMetadata unknownMetadata(String value) {
        return new FieldMetadata().valueUnknown(value);
    }

    public static FieldMetadata trueMetadata() {
        return new FieldMetadata().operator("always true");
    }

    public static FieldMetadata falseMetadata() {
        return new FieldMetadata().operator("always false");
    }

    public static FieldMetadata minMetadata(Collection<? extends Readable> values) {
        return new FieldMetadata().operator("min").valueListReadable(values);
    }

    public static FieldMetadata sumMetadata(Collection<? extends Readable> values) {
        return new FieldMetadata().operator("sum").valueListReadable(values);
    }

    public static FieldMetadata timesMetadata(Readable field, int multiplier) {
        return new FieldMetadata().field(field).operator("times").valueObject(multiplier);
    }

    public static FieldMetadata whenMetadata(Readable field, Readable condition) {
        return new FieldMetadata().field(field).operator("when").valueReadable(condition);
    }

    public static FieldMetadata equalsMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("equals").valueObject(value);
    }

    public static FieldMetadata equalsMetadata(Readable field, Readable value) {
        return new FieldMetadata().field(field).operator("equals").valueReadable(value);
    }

    public static FieldMetadata notEqualsMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("not equals").valueObject(value);
    }

    public static FieldMetadata notEqualsMetadata(Readable field, Readable value) {
        return new FieldMetadata().field(field).operator("not equals").valueReadable(value);
    }

    public static FieldMetadata nullMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("is null");
    }

    public static FieldMetadata notNullMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("is not null");
    }

    public static FieldMetadata matchAnyMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("match any").valueUnknown("lambda");
    }

    public static FieldMetadata matchAnyMetadata(Readable field, Collection<?> values) {
        return new FieldMetadata().field(field).operator("match any").valueListObject(values);
    }

    public static FieldMetadata matchAllMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("match all").valueUnknown("lambda");
    }

    public static FieldMetadata matchAllMetadata(Readable field, Collection<?> values) {
        return new FieldMetadata().field(field).operator("match all").valueListObject(values);
    }

    public static FieldMetadata matchNoneMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("match none").valueUnknown("lamdba");
    }

    public static FieldMetadata matchNoneMetadata(Readable field, Collection<?> values) {
        return new FieldMetadata().field(field).operator("match none").valueListObject(values);
    }

    public static FieldMetadata mapToIntMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("as a number");
    }

    public static FieldMetadata withMetadata(Readable field, Readable adjuster) {
        return new FieldMetadata().field(field).operator("with").valueReadable(adjuster);
    }

    public static FieldMetadata minusMetadata(Readable field, int value, Object unit) {
        return new FieldMetadata().field(field).operator("minus").valueString(value + " " + FieldMetadata.formatUnit(unit));
    }

    public static FieldMetadata minusMetadata(Readable field1, Readable field2, Object unit) {
        return new FieldMetadata().field(field1).operator("minus").field(field2).valueObject(FieldMetadata.formatUnit(unit));
    }

    public static FieldMetadata plusMetadata(Readable field, int value, Object unit) {
        return new FieldMetadata().field(field).operator("plus").valueString(value + " " + FieldMetadata.formatUnit(unit));
    }

    public static FieldMetadata plusMetadata(Readable field1, Readable field2, Object unit) {
        return new FieldMetadata().field(field1).operator("plus").field(field2).valueObject(FieldMetadata.formatUnit(unit));
    }

    public static FieldMetadata afterMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("after").valueObject(value);
    }

    public static FieldMetadata afterMetadata(Readable field1, Readable field2) {
        return new FieldMetadata().field(field1).operator("after").valueReadable(field2);
    }

    public static FieldMetadata afterMetadata(Readable field, Supplier<?> value) {
        return new FieldMetadata().field(field).operator("after").valueSupplier(value);
    }

    public static FieldMetadata beforeMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("before").valueObject(value);
    }

    public static FieldMetadata beforeMetadata(Readable field1, Readable field2) {
        return new FieldMetadata().field(field1).operator("before").valueReadable(field2);
    }

    public static FieldMetadata beforeMetadata(Readable field, Supplier<?> value) {
        return new FieldMetadata().field(field).operator("before").valueSupplier(value);
    }

    public static FieldMetadata ageAtMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("age at").valueObject(value);
    }

    public static FieldMetadata ageAtMetadata(Readable field1, Readable field2) {
        return new FieldMetadata().field(field1).operator("age at").valueReadable(field2);
    }

    public static FieldMetadata ageAtMetadata(Readable field, Supplier<?> supplier) {
        return new FieldMetadata().field(field).operator("age at").valueSupplier(supplier);
    }

    public static FieldMetadata matchesMetadata(Readable field, String value) {
        return new FieldMetadata().field(field).operator("matches").valueString(value);
    }

    public static FieldMetadata containsMetadata(Readable field, String value) {
        return new FieldMetadata().field(field).operator("contains").valueString(value);
    }

    public static FieldMetadata startsWithMetadata(Readable field, String value) {
        return new FieldMetadata().field(field).operator("starts with").valueString(value);
    }

    public static FieldMetadata endsWithMetadata(Readable field, String value) {
        return new FieldMetadata().field(field).operator("ends with").valueString(value);
    }

    public static FieldMetadata notMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("not");
    }

    public static FieldMetadata andMetadata(Readable field, boolean value) {
        return new FieldMetadata().field(field).operator("and").valueObject(value);
    }

    public static FieldMetadata andMetadata(Readable field, Readable value) {
        return new FieldMetadata().field(field).operator("and").valueReadable(value);
    }

    public static FieldMetadata orMetadata(Readable field, boolean value) {
        return new FieldMetadata().field(field).operator("or").valueObject(value);
    }

    public static FieldMetadata orMetadata(Readable field, Readable value) {
        return new FieldMetadata().field(field).operator("or").valueReadable(value);
    }

    public static FieldMetadata xorMetadata(Readable field, boolean value) {
        return new FieldMetadata().field(field).operator("xor").valueObject(value);
    }

    public static FieldMetadata xorMetadata(Readable field, Readable value) {
        return new FieldMetadata().field(field).operator("xor").valueReadable(value);
    }

    public static FieldMetadata isMetadata(Readable field, boolean value) {
        return new FieldMetadata().field(field).operator("is").valueObject(value);
    }

    public static FieldMetadata lesserThanMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("lesser than").valueObject(value);
    }

    public static FieldMetadata lesserThanMetadata(Readable field1, Readable field2) {
        return new FieldMetadata().field(field1).operator("lesser than").valueReadable(field2);
    }

    public static FieldMetadata lesserOrEqualsMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("lesser or equals").valueObject(value);
    }

    public static FieldMetadata lesserOrEqualsMetadata(Readable field1, Readable field2) {
        return new FieldMetadata().field(field1).operator("lesser or equals").valueReadable(field2);
    }

    public static FieldMetadata greaterThanMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("greater than").valueObject(value);
    }

    public static FieldMetadata greaterThanMetadata(Readable field1, Readable field2) {
        return new FieldMetadata().field(field1).operator("greater than").valueReadable(field2);
    }

    public static FieldMetadata greaterOrEqualsMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("greater or equals").valueObject(value);
    }

    public static FieldMetadata greaterOrEqualsMetadata(Readable field1, Readable field2) {
        return new FieldMetadata().field(field1).operator("greater or equals").valueReadable(field2);
    }

    public static FieldMetadata lengthIsMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("length is");
    }

    public static FieldMetadata containsMetadata(Readable field, Object value) {
        return new FieldMetadata().field(field).operator("contains").valueObject(value);
    }

    public static FieldMetadata containsMetadata(Readable field, Collection<Object> values) {
        return new FieldMetadata().field(field).operator("contains").valueListObject(values);
    }

    public static FieldMetadata isEmptyMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("is empty");
    }

    public static FieldMetadata isNotEmptyMetadata(Readable field) {
        return new FieldMetadata().field(field).operator("is not empty");
    }

    public static FieldMetadata hasSizeMetadata(Readable field, int size) {
        return new FieldMetadata().field(field).operator("has size").valueObject(size);
    }

    public static FieldMetadata hasNotSizeMetadata(Readable field, int size) {
        return new FieldMetadata().field(field).operator("has not size").valueObject(size);
    }

    public static FieldMetadata todayMetadata() {
        return new FieldMetadata().valueString("today");
    }

    public static FieldMetadata todayPlusMetadata(int value, Object unit) {
        return new FieldMetadata().valueString("today plus " + value + " " + FieldMetadata.formatUnit(unit));
    }

    public static FieldMetadata todayMinusMetadata(int value, Object unit) {
        return new FieldMetadata().valueString("today minus " + value + " " + FieldMetadata.formatUnit(unit));
    }

    public static FieldMetadata firstDayOfThisMonthMetadata() {
        return new FieldMetadata().valueString("first day of this month");
    }

    public static FieldMetadata firstDayOfThisYearMetadata() {
        return new FieldMetadata().valueString("first day of this year");
    }

    public static FieldMetadata lastDayOfThisMonthMetadata() {
        return new FieldMetadata().valueString("last day of this month");
    }

    public static FieldMetadata lastDayOfThisYearMetadata() {
        return new FieldMetadata().valueString("last day of this year");
    }

    public static FieldMetadata dateMetadata(Object date) {
        return new FieldMetadata().valueString(date.toString());
    }

    public static FieldMetadata firstDayOfMonthMetadata() {
        return new FieldMetadata().valueString("first day of month");
    }

    public static FieldMetadata firstDayOfNextMonthMetadata() {
        return new FieldMetadata().valueString("first day of next month");
    }

    public static FieldMetadata firstDayOfYearMetadata() {
        return new FieldMetadata().valueString("first day of year");
    }

    public static FieldMetadata firstDayOfNextYearMetadata() {
        return new FieldMetadata().valueString("first day of next year");
    }

    public static FieldMetadata lastDayOfMonthMetadata() {
        return new FieldMetadata().valueString("last day of month");
    }

    public static FieldMetadata lastDayOfYearMetadata() {
        return new FieldMetadata().valueString("last day of year");
    }

    private static String formatUnit(Object unit) {
        return unit.toString().toLowerCase();
    }

    private static String formatListReadable(Collection<? extends Readable> readables) {
        return readables.stream().map(Readable::readable).collect(COLLECTOR_LIST);
    }

    private static String formatListObject(Collection<?> readables) {
        return readables.stream().map(Object::toString).collect(COLLECTOR_LIST);
    }

    public static enum Type {
        field,
        operator,
        value,
        unknown;

    }

    public static class Element {
        private final Readable readable;
        private final Type type;

        private Element(Readable readable, Type type) {
            this.readable = readable;
            this.type = type;
        }

        public Readable getReadable() {
            return this.readable;
        }

        public Type getType() {
            return this.type;
        }
    }
}

