/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.meta;

import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;

public class BinaryMetadata
implements Metadata {
    private final Metadata left;
    private final String operator;
    private final Metadata right;

    private BinaryMetadata(Metadata left, String operator, Metadata right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public String getOperator() {
        return this.operator;
    }

    public static BinaryMetadata andMetadata(Metadata left, Metadata right) {
        return new BinaryMetadata(left, "and", right);
    }

    public static BinaryMetadata orMetadata(Metadata left, Metadata right) {
        return new BinaryMetadata(left, "or", right);
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.start(this);
        this.left.accept(visitor);
        visitor.visit(this);
        this.right.accept(visitor);
        visitor.end(this);
    }
}

