/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.field.NumericFieldInfo;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.NaryMetadata;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class NumericCondition<N extends Number>
extends DefaultCondition<N> {
    NumericCondition(DslField field) {
        super(field);
    }

    NumericCondition(DslField field, Metadata metadata, BiFunction<DslModel, Context, Optional<N>> value) {
        super(field, metadata, value);
    }

    abstract NumericCondition<N> numericCondition(DslField var1, Metadata var2, BiFunction<DslModel, Context, Optional<N>> var3);

    public final StepCondition lesserThan(N value) {
        return this.predicate(FieldMetadata.lesserThanMetadata((Readable)this.field, value), (model, context) -> Optional.ofNullable(value), (l, r) -> this.lesserThanFunction().apply(l, r));
    }

    public final StepCondition lesserThan(NumericFieldInfo<N> value) {
        return this.predicate(FieldMetadata.lesserThanMetadata((Readable)this.field, value), (model, context) -> this.valueModel((DslModel)model, value), (l, r) -> this.lesserThanFunction().apply(l, r));
    }

    public final StepCondition lesserOrEquals(N value) {
        return this.predicate(FieldMetadata.lesserOrEqualsMetadata((Readable)this.field, value), (model, context) -> Optional.ofNullable(value), (l, r) -> this.lesserOrEqualsFunction().apply(l, r));
    }

    public final StepCondition lesserOrEquals(NumericFieldInfo<N> value) {
        return this.predicate(FieldMetadata.lesserOrEqualsMetadata((Readable)this.field, value), (model, context) -> this.valueModel((DslModel)model, value), (l, r) -> this.lesserOrEqualsFunction().apply(l, r));
    }

    public abstract BiFunction<N, N, Boolean> lesserThanFunction();

    public abstract BiFunction<N, N, Boolean> lesserOrEqualsFunction();

    public final StepCondition greaterThan(N value) {
        return this.predicate(FieldMetadata.greaterThanMetadata((Readable)this.field, value), (model, context) -> Optional.ofNullable(value), (l, r) -> this.greaterThanFunction().apply(l, r));
    }

    public final StepCondition greaterThan(NumericFieldInfo<N> value) {
        return this.predicate(FieldMetadata.greaterThanMetadata((Readable)this.field, value), (model, context) -> this.valueModel((DslModel)model, value), (l, r) -> this.greaterThanFunction().apply(l, r));
    }

    public final StepCondition greaterOrEquals(N value) {
        return this.predicate(FieldMetadata.greaterOrEqualsMetadata((Readable)this.field, value), (model, context) -> Optional.ofNullable(value), (l, r) -> this.greaterOrEqualsFunction().apply(l, r));
    }

    public final StepCondition greaterOrEquals(NumericFieldInfo<N> value) {
        return this.predicate(FieldMetadata.greaterOrEqualsMetadata((Readable)this.field, value), (model, context) -> this.valueModel((DslModel)model, value), (l, r) -> this.greaterOrEqualsFunction().apply(l, r));
    }

    public abstract BiFunction<N, N, Boolean> greaterThanFunction();

    public abstract BiFunction<N, N, Boolean> greaterOrEqualsFunction();

    public final StepCondition between(N minIncluded, N maxExcluded) {
        return this.greaterOrEquals(minIncluded).and(this.lesserThan(maxExcluded));
    }

    public final StepCondition between(NumericFieldInfo<N> minIncluded, NumericFieldInfo<N> maxExcluded) {
        return this.greaterOrEquals(minIncluded).and(this.lesserThan(maxExcluded));
    }

    public final NumericCondition<N> min(List<NumericFieldInfo<N>> fields) {
        return this.numericCondition(null, NaryMetadata.minMetadata(NumericCondition.getMetadataForFields(fields)), (model, context) -> fields.stream().map(f -> Optional.ofNullable(model.get(f.id()))).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).reduce(this.minFunction()));
    }

    abstract BinaryOperator<N> minFunction();

    public final NumericCondition<N> sum(List<NumericFieldInfo<N>> fields) {
        return this.numericCondition(null, NaryMetadata.sumMetadata(NumericCondition.getMetadataForFields(fields)), (model, context) -> Optional.of(fields.stream().map(f -> Optional.ofNullable(model.get(f.id()))).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).reduce(this.identity(), this.sumFunction())));
    }

    public final NumericCondition<N> sumConditions(List<NumericCondition<N>> conditions) {
        return this.numericCondition(null, NaryMetadata.sumMetadata(NumericCondition.getMetadataForConditions(conditions)), (model, context) -> Optional.of(conditions.stream().map(c -> (Optional)c.function.apply(model, context)).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).reduce(this.identity(), this.sumFunction())));
    }

    abstract BinaryOperator<N> sumFunction();

    public final NumericCondition<N> times(int multiplier) {
        return this.numericCondition(this.field, FieldMetadata.timesMetadata(this.field, multiplier), (model, context) -> this.valueModel((DslModel)model, this.field).map(v -> (Number)this.timesFunction().apply(v, multiplier)));
    }

    abstract BiFunction<N, Integer, N> timesFunction();

    public final NumericCondition<N> when(StepCondition condition) {
        return this.numericCondition(this.field, FieldMetadata.whenMetadata(this.field, condition), (model, context) -> condition.predicate().test((DslModel)model, (Context)context) ? this.valueModel((DslModel)model, this.field) : Optional.empty());
    }

    abstract N identity();

    private static <N extends Number> List<Metadata> getMetadataForFields(List<NumericFieldInfo<N>> fields) {
        return fields.stream().map(field -> field.getNumericCondition().metadata).collect(Collectors.toList());
    }

    private static <N extends Number> List<Metadata> getMetadataForConditions(List<NumericCondition<N>> conditions) {
        return conditions.stream().map(condition -> condition.metadata).collect(Collectors.toList());
    }
}

