/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.impl.DefaultCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.Metadata;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class IterableCondition<T, C extends Iterable<T>>
extends DefaultCondition<C> {
    public IterableCondition(DslField field) {
        super(field);
    }

    public IterableCondition(DslField field, FieldMetadata metadata, BiFunction<DslModel, Context, Optional<C>> value) {
        super(field, (Metadata)metadata, value);
    }

    public StepCondition contains(T value) {
        return this.predicate(FieldMetadata.containsMetadata((Readable)this.field, value), collection -> StreamSupport.stream(collection.spliterator(), false).anyMatch(value::equals));
    }

    @SafeVarargs
    public final StepCondition containsAll(T ... values) {
        return this.predicate(FieldMetadata.containsMetadata((Readable)this.field, values), iterable -> StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet()).containsAll(Arrays.asList(values)));
    }

    public StepCondition isEmpty() {
        return this.predicate(FieldMetadata.isEmptyMetadata(this.field), iterable -> !iterable.iterator().hasNext());
    }

    public StepCondition isNotEmpty() {
        return this.predicate(FieldMetadata.isNotEmptyMetadata(this.field), iterable -> iterable.iterator().hasNext());
    }

    public StepCondition hasSize(int size) {
        return this.predicate(FieldMetadata.hasSizeMetadata(this.field, size), iterable -> StreamSupport.stream(iterable.spliterator(), false).count() == (long)size);
    }

    public StepCondition hasNotSize(int size) {
        return this.predicate(FieldMetadata.hasNotSizeMetadata(this.field, size), iterable -> StreamSupport.stream(iterable.spliterator(), false).count() != (long)size);
    }
}

