/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslField;
import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.field.BaseFieldInfo;
import io.doov.core.dsl.impl.AbstractCondition;
import io.doov.core.dsl.impl.IntegerCondition;
import io.doov.core.dsl.impl.PredicateStepCondition;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.Readable;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.FieldMetadata;
import io.doov.core.dsl.meta.Metadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class DefaultCondition<T>
extends AbstractCondition<T> {
    public DefaultCondition(DslField field) {
        super(field);
    }

    public DefaultCondition(DslField field, Metadata metadata, BiFunction<DslModel, Context, Optional<T>> value) {
        super(field, metadata, value);
    }

    public final StepCondition isNull() {
        return new PredicateStepCondition<Optional>(this.metadata.merge(FieldMetadata.nullMetadata(this.field)), (model, context) -> Optional.of(this.function.apply(model, context)), optional -> !optional.isPresent());
    }

    public final StepCondition isNotNull() {
        return new PredicateStepCondition<Optional>(this.metadata.merge(FieldMetadata.notNullMetadata(this.field)), (model, context) -> Optional.of(this.function.apply(model, context)), Optional::isPresent);
    }

    public final StepCondition eq(T value) {
        return this.predicate(FieldMetadata.equalsMetadata((Readable)this.field, value), (model, context) -> Optional.ofNullable(value), Object::equals);
    }

    public final StepCondition eq(Supplier<T> value) {
        return this.predicate(FieldMetadata.equalsMetadata((Readable)this.field, value), (model, context) -> Optional.ofNullable(value.get()), Object::equals);
    }

    public final StepCondition eq(BaseFieldInfo<T> value) {
        return this.predicate(FieldMetadata.equalsMetadata((Readable)this.field, value), (model, context) -> this.valueModel((DslModel)model, value), Object::equals);
    }

    public final StepCondition eq(DefaultCondition<T> value) {
        return this.predicate(FieldMetadata.equalsMetadata((Readable)this.field, value), value.function, Object::equals);
    }

    public final StepCondition notEq(T value) {
        return this.predicate(FieldMetadata.notEqualsMetadata((Readable)this.field, value), (model, context) -> Optional.ofNullable(value), (l, r) -> !l.equals(r));
    }

    public final StepCondition notEq(Supplier<T> value) {
        return this.predicate(FieldMetadata.notEqualsMetadata((Readable)this.field, value), (model, context) -> Optional.ofNullable(value.get()), (l, r) -> !l.equals(r));
    }

    public final StepCondition notEq(BaseFieldInfo<T> value) {
        return this.predicate(FieldMetadata.notEqualsMetadata((Readable)this.field, value), (model, context) -> this.valueModel((DslModel)model, value), (l, r) -> !l.equals(r));
    }

    public final StepCondition notEq(DefaultCondition<T> value) {
        return this.predicate(FieldMetadata.notEqualsMetadata((Readable)this.field, value), value.function, (l, r) -> !l.equals(r));
    }

    @SafeVarargs
    public final StepCondition anyMatch(T ... values) {
        return this.predicate(FieldMetadata.matchAnyMetadata(this.field, Arrays.asList(values)), value -> Arrays.stream(values).anyMatch(value::equals));
    }

    public final StepCondition anyMatch(Collection<T> values) {
        return this.predicate(FieldMetadata.matchAnyMetadata(this.field, values), value -> values.stream().anyMatch(value::equals));
    }

    public final StepCondition anyMatch(List<Predicate<T>> values) {
        return this.predicate(FieldMetadata.matchAnyMetadata(this.field), value -> values.stream().anyMatch((? super T v) -> v.test(value)));
    }

    @SafeVarargs
    public final StepCondition allMatch(T ... values) {
        return this.predicate(FieldMetadata.matchAllMetadata(this.field, Arrays.asList(values)), value -> Arrays.stream(values).allMatch(value::equals));
    }

    public final StepCondition allMatch(Collection<T> values) {
        return this.predicate(FieldMetadata.matchAllMetadata(this.field, values), value -> values.stream().allMatch(value::equals));
    }

    public final StepCondition allMatch(List<Predicate<T>> values) {
        return this.predicate(FieldMetadata.matchAllMetadata(this.field), value -> values.stream().allMatch((? super T v) -> v.test(value)));
    }

    @SafeVarargs
    public final StepCondition noneMatch(T ... values) {
        return this.predicate(FieldMetadata.matchNoneMetadata(this.field, Arrays.asList(values)), value -> Arrays.stream(values).noneMatch(value::equals));
    }

    public final StepCondition noneMatch(Collection<T> values) {
        return this.predicate(FieldMetadata.matchNoneMetadata(this.field, values), value -> values.stream().noneMatch(value::equals));
    }

    public final StepCondition noneMatch(List<Predicate<T>> values) {
        return this.predicate(FieldMetadata.matchNoneMetadata(this.field), value -> values.stream().noneMatch((? super T v) -> v.test(value)));
    }

    public final IntegerCondition mapToInt(Function<T, Integer> mapper) {
        return new IntegerCondition(this.field, (Metadata)FieldMetadata.mapToIntMetadata(this.field), (model, context) -> this.valueModel((DslModel)model, this.field).flatMap(l -> Optional.of(mapper.apply(l))));
    }
}

