/*
 * Decompiled with CFR 0.152.
 */
package io.doov.core.dsl.impl;

import io.doov.core.dsl.DslModel;
import io.doov.core.dsl.lang.Context;
import io.doov.core.dsl.lang.StepCondition;
import io.doov.core.dsl.meta.Metadata;
import io.doov.core.dsl.meta.MetadataVisitor;
import io.doov.core.dsl.meta.ast.AstVisitorUtils;
import java.util.function.BiPredicate;

abstract class AbstractStepCondition
implements StepCondition {
    private final Metadata metadata;
    private final BiPredicate<DslModel, Context> predicate;

    protected AbstractStepCondition(Metadata metadata, BiPredicate<DslModel, Context> predicate) {
        this.metadata = metadata;
        this.predicate = predicate;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public BiPredicate<DslModel, Context> predicate() {
        return (model, context) -> {
            boolean test = this.predicate.test((DslModel)model, (Context)context);
            if (!test) {
                context.failed(this.metadata);
            }
            return test;
        };
    }

    @Override
    public String readable() {
        return AstVisitorUtils.astToString(this);
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
        this.metadata.accept(visitor);
    }
}

