/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.client.sample.spi;

import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.client.sample.BatchConsumerTable;
import io.resys.thena.client.sample.FindAllFilter;
import io.resys.thena.client.sample.FindAllUsingSqlBuilder;
import io.resys.thena.client.sample.entities.BatchConsumer;
import io.resys.thena.client.sample.spi.Batch2TableNames;
import io.resys.thena.datasource.ImmutableSql;
import io.resys.thena.datasource.ImmutableSqlTuple;
import io.resys.thena.datasource.ImmutableSqlTupleList;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchConsumerTableImpl
implements BatchConsumerTable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchConsumerTableImpl.class);
    private final Batch2TableNames tables;
    private final ThenaSqlDataSource dataSource;
    private final ThenaSqlDataSourceErrorHandler errorHandler;

    public BatchConsumerTableImpl(Batch2TableNames tables, ThenaSqlDataSource dataSource) {
        this.tables = tables;
        this.dataSource = dataSource;
        this.errorHandler = dataSource.getErrorHandler();
    }

    @Override
    public ThenaSqlClient.Sql findAll() {
        return ImmutableSql.builder().value("SELECT * FROM " + this.tables.getBatchConsumers()).rowMapper((TenantSql.RowMapper)new BatchConsumerTable.BatchConsumerMapper()).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple getById(String id) {
        return ImmutableSqlTuple.builder().value("SELECT * FROM " + this.tables.getBatchConsumers() + " WHERE id = $1").props(Tuple.of((Object)id)).rowMapper((TenantSql.RowMapper)new BatchConsumerTable.BatchConsumerMapper()).build();
    }

    @Override
    public ThenaSqlClient.Sql findAllEnabled() {
        return ImmutableSql.builder().value("SELECT * FROM " + this.tables.getBatchConsumers() + " WHERE consumer_status = 'ENABLED'").rowMapper((TenantSql.RowMapper)new BatchConsumerTable.BatchConsumerMapper()).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple findAllEnabledByAppId(String appId) {
        return ImmutableSqlTuple.builder().value("SELECT * FROM " + this.tables.getBatchConsumers() + " WHERE consumer_status = 'ENABLED' AND app_id = $1").props(Tuple.of((Object)appId)).rowMapper((TenantSql.RowMapper)new BatchConsumerTable.BatchConsumerMapper()).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple findAllUsingSqlBuilder(FindAllFilter filter) {
        FindAllUsingSqlBuilder sqlBuilder = new FindAllUsingSqlBuilder();
        ThenaSqlClient.SqlTuple baseSql = sqlBuilder.apply(this.dataSource.getTenant(), "", filter);
        String sqlValue = baseSql.getValue();
        sqlValue = sqlValue.replaceAll("(?i)\\{batch_consumers\\}", this.tables.getBatchConsumers());
        return ImmutableSqlTuple.builder().value(sqlValue).props(baseSql.getProps()).rowMapper((TenantSql.RowMapper)new BatchConsumerTable.BatchConsumerMapper()).build();
    }

    @Override
    public ThenaSqlClient.SqlTupleList insertMany(List<BatchConsumer> users) {
        BatchConsumerTable.BatchConsumerInsertMapper mapper = new BatchConsumerTable.BatchConsumerInsertMapper();
        return ImmutableSqlTupleList.builder().value("INSERT INTO " + this.tables.getBatchConsumers() + " (id, app_id, batch_name, consumer_name, consumer_qualified_java_name, consumer_status, consumer_comment, consumer_created_at, consumer_created_by, consumer_updated_at, consumer_updated_by) VALUES($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11)").props((Iterable)users.stream().map(mapper::apply).collect(Collectors.toList())).build();
    }

    @Override
    public ThenaSqlClient.SqlTupleList updateMany(List<BatchConsumer> users) {
        BatchConsumerTable.BatchConsumerUpdateMapper mapper = new BatchConsumerTable.BatchConsumerUpdateMapper();
        return ImmutableSqlTupleList.builder().value("UPDATE " + this.tables.getBatchConsumers() + " SET consumer_qualified_java_name = $1, consumer_status = $2, batch_name = $3, consumer_updated_at = $4, consumer_updated_by = $5, consumer_comment = $6 WHERE id = $7").props((Iterable)users.stream().map(mapper::apply).collect(Collectors.toList())).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple findAllByAppId(String appId, boolean lockForUpdate) {
        return ImmutableSqlTuple.builder().value("SELECT consumers.* FROM " + this.tables.getBatchConsumers() + " AS consumers WHERE consumers.app_id = $1 FOR UPDATE").props(Tuple.of((Object)appId, (Object)lockForUpdate)).rowMapper((TenantSql.RowMapper)new BatchConsumerTable.BatchConsumerMapper()).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple deleteById(String id) {
        return ImmutableSqlTuple.builder().value("DELETE FROM " + this.tables.getBatchConsumers() + " WHERE id = $1").props(new BatchConsumerTable.BatchConsumerIdMapper().apply(id)).build();
    }

    @Override
    public ThenaSqlClient.SqlTupleList deleteAll(Collection<BatchConsumer> missionId) {
        BatchConsumerTable.BatchConsumerDeleteMapper mapper = new BatchConsumerTable.BatchConsumerDeleteMapper();
        return ImmutableSqlTupleList.builder().value("DELETE FROM " + this.tables.getBatchConsumers() + " WHERE id = $1").props((Iterable)missionId.stream().map(mapper::apply).collect(Collectors.toList())).build();
    }

    public ThenaSqlClient.Sql createTable() {
        return ImmutableSql.builder().value("CREATE TABLE IF NOT EXISTS " + this.tables.getBatchConsumers() + " ( id VARCHAR(40) PRIMARY KEY, batch_name TEXT NOT NULL, app_id TEXT NOT NULL, consumer_name TEXT NOT NULL, consumer_qualified_java_name TEXT NOT NULL, consumer_comment TEXT NOT NULL, consumer_status VARCHAR(100) NOT NULL, consumer_created_at TIMESTAMP WITH TIME ZONE NOT NULL, consumer_created_by TEXT NOT NULL, consumer_updated_at TIMESTAMP WITH TIME ZONE, consumer_updated_by TEXT, UNIQUE(batch_name, app_id, consumer_name) ); CREATE INDEX IF NOT EXISTS " + this.tables.getBatchConsumers() + "_APP_INDEX ON " + this.tables.getBatchConsumers() + " (app_id); CREATE INDEX IF NOT EXISTS " + this.tables.getBatchConsumers() + "_BATCH_NAME_INDEX ON " + this.tables.getBatchConsumers() + " (batch_name); CREATE INDEX IF NOT EXISTS " + this.tables.getBatchConsumers() + "_NAME_INDEX ON " + this.tables.getBatchConsumers() + " (consumer_name);").build();
    }

    public ThenaSqlClient.Sql createConstraints() {
        return ImmutableSql.builder().value("--- constraints for " + this.tables.getBatchConsumers()).build();
    }

    public ThenaSqlClient.Sql dropTable() {
        return ImmutableSql.builder().value("DROP TABLE " + this.tables.getBatchConsumers() + ";").build();
    }

    @Generated
    public Batch2TableNames getTables() {
        return this.tables;
    }

    @Generated
    public ThenaSqlDataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public ThenaSqlDataSourceErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchConsumerTableImpl)) {
            return false;
        }
        BatchConsumerTableImpl other = (BatchConsumerTableImpl)o;
        Batch2TableNames this$tables = this.getTables();
        Batch2TableNames other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables)) {
            return false;
        }
        ThenaSqlDataSource this$dataSource = this.getDataSource();
        ThenaSqlDataSource other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        ThenaSqlDataSourceErrorHandler this$errorHandler = this.getErrorHandler();
        ThenaSqlDataSourceErrorHandler other$errorHandler = other.getErrorHandler();
        return !(this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Batch2TableNames $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        ThenaSqlDataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        ThenaSqlDataSourceErrorHandler $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BatchConsumerTableImpl(tables=" + String.valueOf(this.getTables()) + ", dataSource=" + String.valueOf(this.getDataSource()) + ", errorHandler=" + String.valueOf(this.getErrorHandler()) + ")";
    }

    @Generated
    public BatchConsumerTableImpl(Batch2TableNames tables, ThenaSqlDataSource dataSource, ThenaSqlDataSourceErrorHandler errorHandler) {
        this.tables = tables;
        this.dataSource = dataSource;
        this.errorHandler = errorHandler;
    }
}

