/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.client.sample.spi;

import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.client.sample.Batch2DbQuery;
import io.resys.thena.client.sample.FindAllFilter;
import io.resys.thena.client.sample.ImmutableWorld;
import io.resys.thena.client.sample.entities.BatchConsumer;
import io.resys.thena.client.sample.spi.Batch2FindException;
import io.resys.thena.client.sample.spi.Batch2Registry;
import io.resys.thena.client.sample.spi.Batch2TableNames;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.RowIterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch2DbQueryImpl
implements Batch2DbQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"io.resys.thena.show_sql");
    private final ThenaSqlDataSource dataSource;
    private final Batch2Registry registry;
    private final ThenaSqlDataSourceErrorHandler errorHandler;

    public Batch2DbQueryImpl(ThenaSqlDataSource dataSource) {
        this.dataSource = dataSource;
        Batch2TableNames names = Batch2TableNames.defaults().toRepo(dataSource.getTenant());
        this.registry = new Batch2Registry(names, dataSource);
        this.errorHandler = dataSource.getErrorHandler();
    }

    @Override
    public Uni<Batch2DbQuery.World> findAll() {
        return Uni.combine().all().unis(new Uni[]{this.queryBatchConsumers().findAll()}).with(sets -> {
            ImmutableWorld.Builder builder = ImmutableWorld.builder();
            List item_0 = (List)sets.get(0);
            builder.batchConsumers(item_0.stream().collect(Collectors.toMap(e -> e.getId(), e -> e)));
            return builder.build();
        });
    }

    @Override
    public Batch2DbQuery.BatchConsumersQuery queryBatchConsumers() {
        return new Batch2DbQuery.BatchConsumersQuery(){

            @Override
            public Uni<List<BatchConsumer>> findAll() {
                ThenaSqlClient.Sql sql = Batch2DbQueryImpl.this.registry.batchConsumers().findAll();
                if (log.isDebugEnabled()) {
                    log.debug("Batch2DbQueryImpl.queryBatchConsumers.findAll query, with props: {} \r\n{}", (Object)"", (Object)sql.getValue());
                }
                TenantSql.RowMapper mapper = sql.getRowMapper();
                return Batch2DbQueryImpl.this.dataSource.getClient().preparedQuery(sql.getValue()).mapping(arg_0 -> ((TenantSql.RowMapper)mapper).apply(arg_0)).execute().onItem().transformToUni(rowset -> Multi.createFrom().iterable((Iterable)rowset).collect().asList()).onFailure().invoke(e -> Batch2DbQueryImpl.this.errorHandler.deadEnd(new ThenaSqlDataSourceErrorHandler.SqlFailed("Can't find 'BATCH_CONSUMERS's!", sql, e)));
            }

            @Override
            public Uni<BatchConsumer> getById(String id) {
                ThenaSqlClient.SqlTuple sql = Batch2DbQueryImpl.this.registry.batchConsumers().getById(id);
                if (log.isDebugEnabled()) {
                    log.debug("Batch2DbQueryImpl.queryBatchConsumers.getById query, with props: {} \r\n{}", (Object)sql.getProps().deepToString(), (Object)sql.getValue());
                }
                TenantSql.RowMapper mapper = sql.getRowMapper();
                return Batch2DbQueryImpl.this.dataSource.getClient().preparedQuery(sql.getValue()).mapping(arg_0 -> ((TenantSql.RowMapper)mapper).apply(arg_0)).execute(sql.getProps()).onItem().transform(rowset -> {
                    RowIterator iterator = rowset.iterator();
                    if (iterator.hasNext()) {
                        return (BatchConsumer)iterator.next();
                    }
                    throw new Batch2FindException("io.resys.thena.client.sample.entities.BatchConsumer not found!");
                }).onFailure().invoke(e -> Batch2DbQueryImpl.this.errorHandler.deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't find 'BATCH_CONSUMERS's!", sql, e)));
            }

            @Override
            public Multi<BatchConsumer> findAllEnabled() {
                ThenaSqlClient.Sql sql = Batch2DbQueryImpl.this.registry.batchConsumers().findAllEnabled();
                if (log.isDebugEnabled()) {
                    log.debug("Batch2DbQueryImpl.queryBatchConsumers.findAllEnabled query, with props: {} \r\n{}", (Object)"", (Object)sql.getValue());
                }
                TenantSql.RowMapper mapper = sql.getRowMapper();
                return Batch2DbQueryImpl.this.dataSource.getClient().preparedQuery(sql.getValue()).mapping(arg_0 -> ((TenantSql.RowMapper)mapper).apply(arg_0)).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable((Iterable)rowset)).onFailure().invoke(e -> Batch2DbQueryImpl.this.errorHandler.deadEnd(new ThenaSqlDataSourceErrorHandler.SqlFailed("Can't find 'BATCH_CONSUMERS's!", sql, e)));
            }

            @Override
            public Uni<List<BatchConsumer>> findAllEnabledByAppId(String appId) {
                ThenaSqlClient.SqlTuple sql = Batch2DbQueryImpl.this.registry.batchConsumers().findAllEnabledByAppId(appId);
                if (log.isDebugEnabled()) {
                    log.debug("Batch2DbQueryImpl.queryBatchConsumers.findAllEnabledByAppId query, with props: {} \r\n{}", (Object)sql.getProps().deepToString(), (Object)sql.getValue());
                }
                TenantSql.RowMapper mapper = sql.getRowMapper();
                return Batch2DbQueryImpl.this.dataSource.getClient().preparedQuery(sql.getValue()).mapping(arg_0 -> ((TenantSql.RowMapper)mapper).apply(arg_0)).execute(sql.getProps()).onItem().transformToUni(rowset -> Multi.createFrom().iterable((Iterable)rowset).collect().asList()).onFailure().invoke(e -> Batch2DbQueryImpl.this.errorHandler.deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't find 'BATCH_CONSUMERS's!", sql, e)));
            }

            @Override
            public Uni<List<BatchConsumer>> findAllUsingSqlBuilder(FindAllFilter filter) {
                ThenaSqlClient.SqlTuple sql = Batch2DbQueryImpl.this.registry.batchConsumers().findAllUsingSqlBuilder(filter);
                if (log.isDebugEnabled()) {
                    log.debug("Batch2DbQueryImpl.queryBatchConsumers.findAllUsingSqlBuilder query, with props: {} \r\n{}", (Object)sql.getProps().deepToString(), (Object)sql.getValue());
                }
                TenantSql.RowMapper mapper = sql.getRowMapper();
                return Batch2DbQueryImpl.this.dataSource.getClient().preparedQuery(sql.getValue()).mapping(arg_0 -> ((TenantSql.RowMapper)mapper).apply(arg_0)).execute(sql.getProps()).onItem().transformToUni(rowset -> Multi.createFrom().iterable((Iterable)rowset).collect().asList()).onFailure().invoke(e -> Batch2DbQueryImpl.this.errorHandler.deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't find 'BATCH_CONSUMERS's!", sql, e)));
            }

            @Override
            public Uni<List<BatchConsumer>> findAllByAppId(String appId, boolean lockForUpdate) {
                ThenaSqlClient.SqlTuple sql = Batch2DbQueryImpl.this.registry.batchConsumers().findAllByAppId(appId, lockForUpdate);
                if (log.isDebugEnabled()) {
                    log.debug("Batch2DbQueryImpl.queryBatchConsumers.findAllByAppId query, with props: {} \r\n{}", (Object)sql.getProps().deepToString(), (Object)sql.getValue());
                }
                TenantSql.RowMapper mapper = sql.getRowMapper();
                return Batch2DbQueryImpl.this.dataSource.getClient().preparedQuery(sql.getValue()).mapping(arg_0 -> ((TenantSql.RowMapper)mapper).apply(arg_0)).execute(sql.getProps()).onItem().transformToUni(rowset -> Multi.createFrom().iterable((Iterable)rowset).collect().asList()).onFailure().invoke(e -> Batch2DbQueryImpl.this.errorHandler.deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't find 'BATCH_CONSUMERS's!", sql, e)));
            }
        };
    }

    @Generated
    public Batch2DbQueryImpl(ThenaSqlDataSource dataSource, Batch2Registry registry, ThenaSqlDataSourceErrorHandler errorHandler) {
        this.dataSource = dataSource;
        this.registry = registry;
        this.errorHandler = errorHandler;
    }
}

