/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.client.sample.spi;

import io.resys.thena.api.entities.Tenant;
import io.resys.thena.client.sample.spi.Batch2Registry;
import io.resys.thena.client.sample.spi.Batch2TableNames;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.resys.thena.registry.TenantRegistrySqlImpl;
import io.resys.thena.spi.InternalTenantQueryImpl;
import io.resys.thena.spi.TenantDataSource;
import io.resys.thena.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch2DbInternalTenantQuery
extends InternalTenantQueryImpl
implements TenantDataSource.InternalTenantQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"io.resys.thena.show_sql");

    public Batch2DbInternalTenantQuery(ThenaSqlDataSource dataSource) {
        super(dataSource);
    }

    public Uni<Tenant> insert(Tenant newRepo) {
        Batch2TableNames names = Batch2TableNames.defaults().toRepo(newRepo);
        ThenaSqlDataSource next = this.dataSource.withTenant(newRepo);
        Batch2Registry registry = new Batch2Registry(names, next);
        TenantRegistrySqlImpl sqlQuery = new TenantRegistrySqlImpl(next.getTenantContext());
        ThenaSqlClient.ThenaSqlPool pool = next.getPool();
        return pool.withTransaction(tx -> {
            ThenaSqlClient.SqlTuple tenantInsert = sqlQuery.insertOne(newRepo);
            StringBuilder tablesCreate = new StringBuilder();
            RepoAssert.isTrue((newRepo.getType() == Tenant.StructureType.batch ? 1 : 0) != 0, () -> "Tenant type must be batch", (Object[])new Object[0]);
            tablesCreate.append(registry.batchConsumers().createTable().getValue()).append(registry.batchConsumers().createConstraints().getValue()).toString();
            if (log.isDebugEnabled()) {
                log.debug("Creating schema: " + System.lineSeparator() + tablesCreate.toString());
            }
            Uni create = this.getClient().query(sqlQuery.createTable().getValue()).execute().onItem().transformToUni(data -> Uni.createFrom().voidItem()).onFailure().invoke(e -> next.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlFailed("Can't create table 'TENANT'!", sqlQuery.createTable(), e)));
            Uni insert = tx.preparedQuery(tenantInsert.getValue()).execute(tenantInsert.getProps()).onItem().transformToUni(rowSet -> Uni.createFrom().voidItem()).onFailure().invoke(e -> next.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't insert into 'TENANT'!", tenantInsert, e)));
            Uni nested = tx.query(tablesCreate.toString()).execute().onItem().transformToUni(rowSet -> Uni.createFrom().voidItem()).onFailure().invoke(e -> next.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlSchemaFailed("Can't create tables!", tablesCreate.toString(), e)));
            return create.onItem().transformToUni(junk -> insert).onItem().transformToUni(junk -> nested).onItem().transform(junk -> newRepo).onItem().invoke(newTenant -> this.dataSource.getTenantCache().setTenant(newTenant));
        });
    }

    public Uni<Tenant> delete(Tenant newRepo) {
        Batch2TableNames names = Batch2TableNames.defaults().toRepo(newRepo);
        ThenaSqlDataSource next = this.dataSource.withTenant(newRepo);
        Batch2Registry registry = new Batch2Registry(names, next);
        TenantRegistrySqlImpl sqlQuery = new TenantRegistrySqlImpl(next.getTenantContext());
        ThenaSqlClient.ThenaSqlPool pool = next.getPool();
        return pool.withTransaction(tx -> {
            ThenaSqlClient.SqlTuple tenantDelete = sqlQuery.deleteOne(newRepo);
            StringBuilder tablesDrop = new StringBuilder();
            RepoAssert.isTrue((newRepo.getType() == Tenant.StructureType.batch ? 1 : 0) != 0, () -> "Tenant type must be batch", (Object[])new Object[0]);
            tablesDrop.append(registry.batchConsumers().dropTable().getValue()).toString();
            if (log.isDebugEnabled()) {
                log.debug("Delete tenant by name query, with props: {} \r\n{}", (Object)tenantDelete.getProps().deepToString(), (Object)tenantDelete.getValue());
                log.debug("Drop schema: " + System.lineSeparator() + tablesDrop.toString());
            }
            Uni insert = tx.preparedQuery(tenantDelete.getValue()).execute(tenantDelete.getProps()).onItem().transformToUni(rowSet -> Uni.createFrom().voidItem()).onFailure().invoke(e -> next.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't delete from 'TENANT'!", tenantDelete, e)));
            Uni nested = tx.query(tablesDrop.toString()).execute().onItem().transformToUni(rowSet -> Uni.createFrom().voidItem()).onFailure().invoke(e -> next.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlSchemaFailed("Can't drop tables!", tablesDrop.toString(), e)));
            return insert.onItem().transformToUni(junk -> nested).onItem().transform(junk -> newRepo).onItem().invoke(() -> this.dataSource.getTenantCache().invalidateAll());
        });
    }
}

