/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.client.sample.spi;

import io.resys.thena.api.actions.TenantActions;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.client.sample.Batch2Db;
import io.resys.thena.client.sample.Batch2DbBuilder;
import io.resys.thena.client.sample.Batch2DbQuery;
import io.resys.thena.client.sample.spi.Batch2DbBuilderImpl;
import io.resys.thena.client.sample.spi.Batch2DbInternalTenantQuery;
import io.resys.thena.client.sample.spi.Batch2DbQueryImpl;
import io.resys.thena.datasource.TenantCacheImpl;
import io.resys.thena.datasource.TenantContext;
import io.resys.thena.datasource.ThenaDataSource;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.resys.thena.datasource.ThenaSqlDataSourceImpl;
import io.resys.thena.datasource.vertx.ThenaSqlPoolVertx;
import io.resys.thena.spi.TenantActionsImpl;
import io.resys.thena.spi.TenantDataSource;
import io.resys.thena.spi.TenantException;
import io.resys.thena.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch2DbImpl
implements Batch2Db {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Batch2DbImpl.class);
    private final ThenaSqlDataSource dataSource;

    public ThenaDataSource getDataSource() {
        return this.dataSource;
    }

    public TenantDataSource.InternalTenantQuery tenant() {
        return new Batch2DbInternalTenantQuery(this.dataSource);
    }

    @Override
    public Uni<Batch2Db> withTenant(String tenantId) {
        return this.tenant().getByNameOrId(tenantId).onItem().transformToUni(tenant -> {
            if (tenant == null) {
                return this.tenantNotFound(tenantId);
            }
            return Uni.createFrom().item((Object)this.withTenant((Tenant)tenant));
        });
    }

    @Override
    public Batch2Db withTenant(Tenant tenant) {
        return new Batch2DbImpl(this.dataSource.withTenant(tenant));
    }

    @Override
    public Uni<Batch2Db> withTenant() {
        if (this.dataSource.isTenantLoaded()) {
            return Uni.createFrom().item((Object)this);
        }
        return this.withTenant(this.dataSource.getTenant().getName());
    }

    @Override
    public <R> Uni<R> withTransaction(TenantDataSource.TxScope scope, Batch2Db.Transaction<R> callback) {
        return this.withTenant(scope.getTenantId()).onItem().transformToUni(state -> {
            ThenaSqlDataSource source = (ThenaSqlDataSource)state.getDataSource();
            return source.getPool().withTransaction(conn -> callback.apply(new Batch2DbImpl(source.withTx(conn))));
        });
    }

    @Override
    public Batch2DbQuery query() {
        return new Batch2DbQueryImpl(this.dataSource);
    }

    @Override
    public Batch2DbBuilder builder() {
        return new Batch2DbBuilderImpl(this.dataSource);
    }

    public Uni<Batch2Db> createIfNot() {
        return this.tenant().findByNameOrId(this.dataSource.getTenant().getName()).onItem().transformToUni(repo -> {
            if (repo.isEmpty()) {
                return new TenantActionsImpl((TenantDataSource)this, Tenant.StructureType.batch).commit().name(this.dataSource.getTenant().getName()).build().onItem().transform(commit -> {
                    if (commit.getStatus() != TenantActions.CommitStatus.OK) {
                        String msg = String.join((CharSequence)",", commit.getMessages().stream().map(e -> e.getText()).toList());
                        List<Throwable> ex = commit.getMessages().stream().map(e -> e.getException()).filter(e -> e != null).toList();
                        throw new TenantException("Failed to create tenant: " + msg, ex);
                    }
                    return this.withTenant(commit.getRepo());
                });
            }
            return Uni.createFrom().item((Object)this.withTenant((Tenant)repo.get()));
        });
    }

    private <T> Uni<T> tenantNotFound(String tenantId) {
        return this.tenant().findAll().collect().asList().onItem().transform(tenants -> {
            String text = "Tenant with name: '" + tenantId + "' does not exist!" + " known tenants: '" + String.join((CharSequence)",", tenants.stream().map(r -> r.getName()).toList()) + "'";
            log.error(text);
            throw new RuntimeException(text);
        });
    }

    public static Batch2DbImpl create(TenantContext names, Pool client, ThenaSqlDataSource.TenantCache tenantCache, ThenaSqlDataSourceErrorHandler errorHandler) {
        ThenaSqlPoolVertx pool = new ThenaSqlPoolVertx(client);
        ThenaSqlDataSourceImpl dataSource = new ThenaSqlDataSourceImpl("", names, (ThenaSqlClient.ThenaSqlPool)pool, errorHandler, Optional.empty(), tenantCache);
        return new Batch2DbImpl((ThenaSqlDataSource)dataSource);
    }

    public static Builder create() {
        return new Builder();
    }

    @Generated
    public Batch2DbImpl(ThenaSqlDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static class Builder {
        private Pool client;
        private String db;
        private ThenaSqlDataSourceErrorHandler errorHandler;
        private ThenaSqlDataSource.TenantCache tenantCache;

        public Builder errorHandler(ThenaSqlDataSourceErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder tenant(String db) {
            this.db = db;
            return this;
        }

        public Builder tenantCache(ThenaSqlDataSource.TenantCache tenantCache) {
            this.tenantCache = tenantCache;
            return this;
        }

        public Builder client(Pool client) {
            this.client = client;
            return this;
        }

        public Batch2DbImpl build() {
            RepoAssert.notNull((Object)this.client, () -> "client must be defined!");
            RepoAssert.notNull((Object)this.db, () -> "db must be defined!");
            RepoAssert.notNull((Object)this.errorHandler, () -> "errorHandler must be defined!");
            TenantCacheImpl tenantCache = this.tenantCache == null ? new TenantCacheImpl() : this.tenantCache;
            TenantContext ctx = TenantContext.defaults((String)this.db);
            ThenaSqlPoolVertx pool = new ThenaSqlPoolVertx(this.client);
            ThenaSqlDataSourceImpl dataSource = new ThenaSqlDataSourceImpl(this.db, ctx, (ThenaSqlClient.ThenaSqlPool)pool, this.errorHandler, Optional.empty(), (ThenaSqlDataSource.TenantCache)tenantCache);
            return new Batch2DbImpl((ThenaSqlDataSource)dataSource);
        }
    }
}

