/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.client.sample.spi;

import io.resys.thena.api.entities.BatchLog;
import io.resys.thena.api.entities.BatchStatus;
import io.resys.thena.api.entities.ImmutableBatchLog;
import io.resys.thena.client.sample.Batch2DbBuilder;
import io.resys.thena.client.sample.ImmutablePersistenceUnit;
import io.resys.thena.client.sample.entities.BatchConsumer;
import io.resys.thena.client.sample.spi.Batch2Registry;
import io.resys.thena.client.sample.spi.Batch2TableNames;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.storesql.support.Execute;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Batch2DbBuilderImpl
implements Batch2DbBuilder {
    private static final Logger log = LoggerFactory.getLogger((String)"io.resys.thena.client.sample.batch2.show_sql");
    private final ThenaSqlClient tx;
    private final ThenaSqlDataSource dataSource;
    private final Batch2Registry registry;
    private final StringBuilder txLog;
    private final ImmutablePersistenceUnit.Builder init = ImmutablePersistenceUnit.builder();

    public Batch2DbBuilderImpl(ThenaSqlDataSource dataSource) {
        Batch2TableNames names = Batch2TableNames.defaults().toRepo(dataSource.getTenant());
        this.registry = new Batch2Registry(names, dataSource);
        this.dataSource = dataSource;
        this.tx = dataSource.getClient();
        this.txLog = new StringBuilder();
    }

    @Override
    public Batch2DbBuilder from(Batch2DbBuilder.PersistenceUnit unit) {
        this.init.from(unit);
        return this;
    }

    @Override
    public Uni<Batch2DbBuilder.PersistenceUnit> persist() {
        ImmutablePersistenceUnit entries = this.init.build();
        return Uni.combine().all().unis(this.visitBatchConsumersDeletes(entries), this.visitBatchConsumersInserts(entries), this.visitBatchConsumersUpdates(entries)).with(Batch2DbBuilder.PersistenceUnit.class, items -> this.visitSuccess(entries, (List<Batch2DbBuilder.PersistenceUnit>)items)).onFailure(Batch2BuilderException.class).recoverWithUni(this::visitError);
    }

    private Uni<Batch2DbBuilder.PersistenceUnit> visitBatchConsumersDeletes(Batch2DbBuilder.PersistenceUnit entries) {
        List<BatchConsumer> data = entries.getBatchConsumersDeletes();
        ThenaSqlClient.SqlTupleList sql = this.registry.batchConsumers().deleteAll(data);
        return this.visitExecution(sql, BatchConsumer.class);
    }

    private Uni<Batch2DbBuilder.PersistenceUnit> visitBatchConsumersInserts(Batch2DbBuilder.PersistenceUnit entries) {
        List<BatchConsumer> data = entries.getBatchConsumersInserts();
        ThenaSqlClient.SqlTupleList sql = this.registry.batchConsumers().insertMany(data);
        return this.visitExecution(sql, BatchConsumer.class);
    }

    private Uni<Batch2DbBuilder.PersistenceUnit> visitBatchConsumersUpdates(Batch2DbBuilder.PersistenceUnit entries) {
        List<BatchConsumer> data = entries.getBatchConsumersUpdates();
        ThenaSqlClient.SqlTupleList sql = this.registry.batchConsumers().updateMany(data);
        return this.visitExecution(sql, BatchConsumer.class);
    }

    private Uni<Batch2DbBuilder.PersistenceUnit> visitExecution(ThenaSqlClient.SqlTupleList sql, Class<?> type) {
        this.visitTxLog(sql, type);
        ImmutablePersistenceUnit container = ImmutablePersistenceUnit.builder().tenantId(this.dataSource.getTenant().getId()).status(BatchStatus.OK).log("").build();
        return Execute.apply((ThenaSqlClient)this.tx, (ThenaSqlClient.SqlTupleList)sql).onItem().transform(row -> {
            String text = "Inserted " + (row == null ? 0 : row.rowCount()) + " " + type.getSimpleName() + " entries";
            ArrayList<BatchLog> updatedMessages = new ArrayList<BatchLog>((Collection<BatchLog>)container.getCommitLogs());
            updatedMessages.add((BatchLog)ImmutableBatchLog.builder().text(text).build());
            return ImmutablePersistenceUnit.builder().from(container).commitLogs(updatedMessages).build();
        }).onFailure().transform(t -> {
            String text = "Failed to insert " + sql.getProps().size() + " " + type.getSimpleName() + " entries";
            return new Batch2BuilderException(container, text, (Throwable)t);
        });
    }

    private void visitTxLog(ThenaSqlClient.SqlTupleList sql, Class<?> type) {
        if (sql.getProps().isEmpty()) {
            return;
        }
        this.txLog.append(System.lineSeparator()).append("--- processing ").append(sql.getProps().size()).append(" entries of type: '").append(type.getSimpleName()).append("'").append(sql.getPropsDeepString()).append(System.lineSeparator()).append(sql.getValue()).append(System.lineSeparator());
    }

    private Batch2DbBuilder.PersistenceUnit visitSuccess(Batch2DbBuilder.PersistenceUnit inputContainer, List<Batch2DbBuilder.PersistenceUnit> items) {
        String msg = System.lineSeparator() + "--- TX LOG" + System.lineSeparator() + String.valueOf(this.txLog);
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
        return inputContainer.merge(items.stream().reduce((a, b) -> a.merge((Batch2DbBuilder.PersistenceUnit)b)).orElse(inputContainer));
    }

    private Uni<Batch2DbBuilder.PersistenceUnit> visitError(Throwable ex) {
        String msg = System.lineSeparator() + "--- TX LOG" + System.lineSeparator() + String.valueOf(this.txLog);
        Batch2BuilderException builderError = (Batch2BuilderException)ex;
        log.error("Failed to persist because of: {},\r\n{}", new Object[]{ex.getMessage(), msg, ex});
        return this.tx.rollback().onItem().transform(junk -> ImmutablePersistenceUnit.builder().from(builderError.getContainer()).log(msg).build());
    }

    public static final class Batch2BuilderException
    extends RuntimeException {
        private final Batch2DbBuilder.PersistenceUnit container;

        public Batch2BuilderException(Batch2DbBuilder.PersistenceUnit container, String message, Throwable cause) {
            super(message, cause);
            this.container = container;
        }

        public Batch2DbBuilder.PersistenceUnit getContainer() {
            return this.container;
        }
    }
}

