/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.client.sample;

import io.resys.thena.api.entities.BatchLog;
import io.resys.thena.api.entities.BatchStatus;
import io.resys.thena.client.sample.ImmutablePersistenceUnit;
import io.resys.thena.client.sample.entities.BatchConsumer;
import io.smallrye.mutiny.Uni;
import java.util.List;
import org.immutables.value.Value;

public interface Batch2DbBuilder {
    public Batch2DbBuilder from(PersistenceUnit var1);

    public Uni<PersistenceUnit> persist();

    @Value.Immutable
    public static interface PersistenceUnit {
        public List<String> getCommitMessages();

        public List<String> getCommitAuthors();

        public List<BatchConsumer> getBatchConsumersInserts();

        public List<BatchConsumer> getBatchConsumersUpdates();

        public List<BatchConsumer> getBatchConsumersDeletes();

        public String getTenantId();

        public BatchStatus getStatus();

        public String getLog();

        public List<BatchLog> getCommitLogs();

        default public PersistenceUnit merge(List<PersistenceUnit> src) {
            ImmutablePersistenceUnit.Builder builder = ImmutablePersistenceUnit.builder().from(this);
            src.forEach(entry -> entry.merge(builder));
            return builder.build();
        }

        default public PersistenceUnit merge(PersistenceUnit src) {
            return this.merge(ImmutablePersistenceUnit.builder().from(src)).build();
        }

        default public ImmutablePersistenceUnit.Builder merge(ImmutablePersistenceUnit.Builder target) {
            return target.addAllBatchConsumersInserts(this.getBatchConsumersInserts()).addAllBatchConsumersUpdates(this.getBatchConsumersUpdates()).addAllBatchConsumersDeletes(this.getBatchConsumersDeletes()).addAllCommitLogs(this.getCommitLogs()).addAllCommitMessages(this.getCommitMessages()).addAllCommitAuthors(this.getCommitAuthors());
        }
    }
}

