package io.resys.thena.client.sample.spi;

import io.resys.thena.api.entities.Tenant;
import java.lang.String;
import lombok.Builder;
import lombok.Value;

@Value
@Builder
public final class Batch2TableNames {
  private static final Batch2TableNames DEFAULTS = defaults();

  String prefix;

  String batchConsumers;

  public Batch2TableNames toRepo(Tenant repo) {
    final var prefix = repo.getPrefix();
    return toRepo(prefix);
  }

  public Batch2TableNames toRepo(String prefix) {
    return Batch2TableNames.builder()
      .prefix(prefix)
      .batchConsumers(prefix + DEFAULTS.getBatchConsumers())
      .build();
  }

  public static Batch2TableNames defaults() {
    return Batch2TableNames.builder()
      .prefix("")
      .batchConsumers("batch_consumers")
      .build();
  }
}
