package io.resys.thena.client.sample.entities;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BatchConsumer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBatchConsumer.builder()}.
 */
@Generated(from = "BatchConsumer", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableBatchConsumer implements BatchConsumer {
  private final String id;
  private final String appId;
  private final String consumerName;
  private final String batchName;
  private final String comment;
  private final OffsetDateTime createdAt;
  private final String createdBy;
  private final String qualifiedJavaName;
  private final OffsetDateTime updatedAt;
  private final String updatedBy;

  private ImmutableBatchConsumer(
      String id,
      String appId,
      String consumerName,
      String batchName,
      String comment,
      OffsetDateTime createdAt,
      String createdBy,
      String qualifiedJavaName,
      OffsetDateTime updatedAt,
      String updatedBy) {
    this.id = id;
    this.appId = appId;
    this.consumerName = consumerName;
    this.batchName = batchName;
    this.comment = comment;
    this.createdAt = createdAt;
    this.createdBy = createdBy;
    this.qualifiedJavaName = qualifiedJavaName;
    this.updatedAt = updatedAt;
    this.updatedBy = updatedBy;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code appId} attribute
   */
  @Override
  public String getAppId() {
    return appId;
  }

  /**
   * @return The value of the {@code consumerName} attribute
   */
  @Override
  public String getConsumerName() {
    return consumerName;
  }

  /**
   * @return The value of the {@code batchName} attribute
   */
  @Override
  public String getBatchName() {
    return batchName;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @Override
  public String getComment() {
    return comment;
  }

  /**
   * @return The value of the {@code createdAt} attribute
   */
  @Override
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The value of the {@code createdBy} attribute
   */
  @Override
  public String getCreatedBy() {
    return createdBy;
  }

  /**
   * @return The value of the {@code qualifiedJavaName} attribute
   */
  @Override
  public String getQualifiedJavaName() {
    return qualifiedJavaName;
  }

  /**
   * @return The value of the {@code updatedAt} attribute
   */
  @Override
  public Optional<OffsetDateTime> getUpdatedAt() {
    return Optional.ofNullable(updatedAt);
  }

  /**
   * @return The value of the {@code updatedBy} attribute
   */
  @Override
  public Optional<String> getUpdatedBy() {
    return Optional.ofNullable(updatedBy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BatchConsumer#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBatchConsumer withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableBatchConsumer(
        newValue,
        this.appId,
        this.consumerName,
        this.batchName,
        this.comment,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        this.updatedAt,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BatchConsumer#getAppId() appId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for appId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBatchConsumer withAppId(String value) {
    String newValue = Objects.requireNonNull(value, "appId");
    if (this.appId.equals(newValue)) return this;
    return new ImmutableBatchConsumer(
        this.id,
        newValue,
        this.consumerName,
        this.batchName,
        this.comment,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        this.updatedAt,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BatchConsumer#getConsumerName() consumerName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for consumerName
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBatchConsumer withConsumerName(String value) {
    String newValue = Objects.requireNonNull(value, "consumerName");
    if (this.consumerName.equals(newValue)) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        newValue,
        this.batchName,
        this.comment,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        this.updatedAt,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BatchConsumer#getBatchName() batchName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for batchName
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBatchConsumer withBatchName(String value) {
    String newValue = Objects.requireNonNull(value, "batchName");
    if (this.batchName.equals(newValue)) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        newValue,
        this.comment,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        this.updatedAt,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BatchConsumer#getComment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBatchConsumer withComment(String value) {
    String newValue = Objects.requireNonNull(value, "comment");
    if (this.comment.equals(newValue)) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        this.batchName,
        newValue,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        this.updatedAt,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BatchConsumer#getCreatedAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBatchConsumer withCreatedAt(OffsetDateTime value) {
    if (this.createdAt == value) return this;
    OffsetDateTime newValue = Objects.requireNonNull(value, "createdAt");
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        this.batchName,
        this.comment,
        newValue,
        this.createdBy,
        this.qualifiedJavaName,
        this.updatedAt,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BatchConsumer#getCreatedBy() createdBy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdBy
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBatchConsumer withCreatedBy(String value) {
    String newValue = Objects.requireNonNull(value, "createdBy");
    if (this.createdBy.equals(newValue)) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        this.batchName,
        this.comment,
        this.createdAt,
        newValue,
        this.qualifiedJavaName,
        this.updatedAt,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BatchConsumer#getQualifiedJavaName() qualifiedJavaName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qualifiedJavaName
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableBatchConsumer withQualifiedJavaName(String value) {
    String newValue = Objects.requireNonNull(value, "qualifiedJavaName");
    if (this.qualifiedJavaName.equals(newValue)) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        this.batchName,
        this.comment,
        this.createdAt,
        this.createdBy,
        newValue,
        this.updatedAt,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link BatchConsumer#getUpdatedAt() updatedAt} attribute.
   * @param value The value for updatedAt
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBatchConsumer withUpdatedAt(OffsetDateTime value) {
    OffsetDateTime newValue = Objects.requireNonNull(value, "updatedAt");
    if (this.updatedAt == newValue) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        this.batchName,
        this.comment,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        newValue,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link BatchConsumer#getUpdatedAt() updatedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for updatedAt
   * @return A modified copy or {@code this} if not changed
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableBatchConsumer withUpdatedAt(Optional<? extends OffsetDateTime> optional) {
    OffsetDateTime value = optional.orElse(null);
    if (this.updatedAt == value) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        this.batchName,
        this.comment,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        value,
        this.updatedBy);
  }

  /**
   * Copy the current immutable object by setting a <em>present</em> value for the optional {@link BatchConsumer#getUpdatedBy() updatedBy} attribute.
   * @param value The value for updatedBy
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBatchConsumer withUpdatedBy(String value) {
    String newValue = Objects.requireNonNull(value, "updatedBy");
    if (Objects.equals(this.updatedBy, newValue)) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        this.batchName,
        this.comment,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        this.updatedAt,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link BatchConsumer#getUpdatedBy() updatedBy} attribute.
   * An equality check is used on inner value to prevent copying of the same value by returning {@code this}.
   * @param optional An optional value for updatedBy
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableBatchConsumer withUpdatedBy(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.updatedBy, value)) return this;
    return new ImmutableBatchConsumer(
        this.id,
        this.appId,
        this.consumerName,
        this.batchName,
        this.comment,
        this.createdAt,
        this.createdBy,
        this.qualifiedJavaName,
        this.updatedAt,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBatchConsumer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBatchConsumer
        && equalsByValue((ImmutableBatchConsumer) another);
  }

  private boolean equalsByValue(ImmutableBatchConsumer another) {
    return id.equals(another.id)
        && appId.equals(another.appId)
        && consumerName.equals(another.consumerName)
        && batchName.equals(another.batchName)
        && comment.equals(another.comment)
        && createdAt.equals(another.createdAt)
        && createdBy.equals(another.createdBy)
        && qualifiedJavaName.equals(another.qualifiedJavaName)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(updatedBy, another.updatedBy);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code appId}, {@code consumerName}, {@code batchName}, {@code comment}, {@code createdAt}, {@code createdBy}, {@code qualifiedJavaName}, {@code updatedAt}, {@code updatedBy}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + appId.hashCode();
    h += (h << 5) + consumerName.hashCode();
    h += (h << 5) + batchName.hashCode();
    h += (h << 5) + comment.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + createdBy.hashCode();
    h += (h << 5) + qualifiedJavaName.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(updatedBy);
    return h;
  }

  /**
   * Prints the immutable value {@code BatchConsumer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BatchConsumer")
        .omitNullValues()
        .add("id", id)
        .add("appId", appId)
        .add("consumerName", consumerName)
        .add("batchName", batchName)
        .add("comment", comment)
        .add("createdAt", createdAt)
        .add("createdBy", createdBy)
        .add("qualifiedJavaName", qualifiedJavaName)
        .add("updatedAt", updatedAt)
        .add("updatedBy", updatedBy)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link BatchConsumer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BatchConsumer instance
   */
  public static ImmutableBatchConsumer copyOf(BatchConsumer instance) {
    if (instance instanceof ImmutableBatchConsumer) {
      return (ImmutableBatchConsumer) instance;
    }
    return ImmutableBatchConsumer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBatchConsumer ImmutableBatchConsumer}.
   * <pre>
   * ImmutableBatchConsumer.builder()
   *    .id(String) // required {@link BatchConsumer#getId() id}
   *    .appId(String) // required {@link BatchConsumer#getAppId() appId}
   *    .consumerName(String) // required {@link BatchConsumer#getConsumerName() consumerName}
   *    .batchName(String) // required {@link BatchConsumer#getBatchName() batchName}
   *    .comment(String) // required {@link BatchConsumer#getComment() comment}
   *    .createdAt(java.time.OffsetDateTime) // required {@link BatchConsumer#getCreatedAt() createdAt}
   *    .createdBy(String) // required {@link BatchConsumer#getCreatedBy() createdBy}
   *    .qualifiedJavaName(String) // required {@link BatchConsumer#getQualifiedJavaName() qualifiedJavaName}
   *    .updatedAt(Optional&lt;java.time.OffsetDateTime&gt;) // optional {@link BatchConsumer#getUpdatedAt() updatedAt}
   *    .updatedBy(Optional&lt;String&gt;) // optional {@link BatchConsumer#getUpdatedBy() updatedBy}
   *    .build();
   * </pre>
   * @return A new ImmutableBatchConsumer builder
   */
  public static ImmutableBatchConsumer.Builder builder() {
    return new ImmutableBatchConsumer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBatchConsumer ImmutableBatchConsumer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BatchConsumer", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_APP_ID = 0x2L;
    private static final long INIT_BIT_CONSUMER_NAME = 0x4L;
    private static final long INIT_BIT_BATCH_NAME = 0x8L;
    private static final long INIT_BIT_COMMENT = 0x10L;
    private static final long INIT_BIT_CREATED_AT = 0x20L;
    private static final long INIT_BIT_CREATED_BY = 0x40L;
    private static final long INIT_BIT_QUALIFIED_JAVA_NAME = 0x80L;
    private long initBits = 0xffL;

    private String id;
    private String appId;
    private String consumerName;
    private String batchName;
    private String comment;
    private OffsetDateTime createdAt;
    private String createdBy;
    private String qualifiedJavaName;
    private OffsetDateTime updatedAt;
    private String updatedBy;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchConsumer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BatchConsumer instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.appId(instance.getAppId());
      this.consumerName(instance.getConsumerName());
      this.batchName(instance.getBatchName());
      this.comment(instance.getComment());
      this.createdAt(instance.getCreatedAt());
      this.createdBy(instance.getCreatedBy());
      this.qualifiedJavaName(instance.getQualifiedJavaName());
      Optional<OffsetDateTime> updatedAtOptional = instance.getUpdatedAt();
      if (updatedAtOptional.isPresent()) {
        updatedAt(updatedAtOptional);
      }
      Optional<String> updatedByOptional = instance.getUpdatedBy();
      if (updatedByOptional.isPresent()) {
        updatedBy(updatedByOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BatchConsumer#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchConsumer#getAppId() appId} attribute.
     * @param appId The value for appId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder appId(String appId) {
      this.appId = Objects.requireNonNull(appId, "appId");
      initBits &= ~INIT_BIT_APP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchConsumer#getConsumerName() consumerName} attribute.
     * @param consumerName The value for consumerName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder consumerName(String consumerName) {
      this.consumerName = Objects.requireNonNull(consumerName, "consumerName");
      initBits &= ~INIT_BIT_CONSUMER_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchConsumer#getBatchName() batchName} attribute.
     * @param batchName The value for batchName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder batchName(String batchName) {
      this.batchName = Objects.requireNonNull(batchName, "batchName");
      initBits &= ~INIT_BIT_BATCH_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchConsumer#getComment() comment} attribute.
     * @param comment The value for comment 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      initBits &= ~INIT_BIT_COMMENT;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchConsumer#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchConsumer#getCreatedBy() createdBy} attribute.
     * @param createdBy The value for createdBy 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder createdBy(String createdBy) {
      this.createdBy = Objects.requireNonNull(createdBy, "createdBy");
      initBits &= ~INIT_BIT_CREATED_BY;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchConsumer#getQualifiedJavaName() qualifiedJavaName} attribute.
     * @param qualifiedJavaName The value for qualifiedJavaName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder qualifiedJavaName(String qualifiedJavaName) {
      this.qualifiedJavaName = Objects.requireNonNull(qualifiedJavaName, "qualifiedJavaName");
      initBits &= ~INIT_BIT_QUALIFIED_JAVA_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link BatchConsumer#getUpdatedAt() updatedAt} to updatedAt.
     * @param updatedAt The value for updatedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder updatedAt(OffsetDateTime updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link BatchConsumer#getUpdatedAt() updatedAt} to updatedAt.
     * @param updatedAt The value for updatedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder updatedAt(Optional<? extends OffsetDateTime> updatedAt) {
      this.updatedAt = updatedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link BatchConsumer#getUpdatedBy() updatedBy} to updatedBy.
     * @param updatedBy The value for updatedBy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder updatedBy(String updatedBy) {
      this.updatedBy = Objects.requireNonNull(updatedBy, "updatedBy");
      return this;
    }

    /**
     * Initializes the optional value {@link BatchConsumer#getUpdatedBy() updatedBy} to updatedBy.
     * @param updatedBy The value for updatedBy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder updatedBy(Optional<String> updatedBy) {
      this.updatedBy = updatedBy.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBatchConsumer ImmutableBatchConsumer}.
     * @return An immutable instance of BatchConsumer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBatchConsumer build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBatchConsumer(
          id,
          appId,
          consumerName,
          batchName,
          comment,
          createdAt,
          createdBy,
          qualifiedJavaName,
          updatedAt,
          updatedBy);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_APP_ID) != 0) attributes.add("appId");
      if ((initBits & INIT_BIT_CONSUMER_NAME) != 0) attributes.add("consumerName");
      if ((initBits & INIT_BIT_BATCH_NAME) != 0) attributes.add("batchName");
      if ((initBits & INIT_BIT_COMMENT) != 0) attributes.add("comment");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_CREATED_BY) != 0) attributes.add("createdBy");
      if ((initBits & INIT_BIT_QUALIFIED_JAVA_NAME) != 0) attributes.add("qualifiedJavaName");
      return "Cannot build BatchConsumer, some of required attributes are not set " + attributes;
    }
  }
}
