package io.resys.thena.client.sample;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.client.sample.entities.BatchConsumer;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Batch2DbQuery.World}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWorld.builder()}.
 */
@Generated(from = "Batch2DbQuery.World", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableWorld implements Batch2DbQuery.World {
  private final ImmutableMap<String, BatchConsumer> batchConsumers;

  private ImmutableWorld(
      ImmutableMap<String, BatchConsumer> batchConsumers) {
    this.batchConsumers = batchConsumers;
  }

  /**
   * @return The value of the {@code batchConsumers} attribute
   */
  @Override
  public ImmutableMap<String, BatchConsumer> getBatchConsumers() {
    return batchConsumers;
  }

  /**
   * Copy the current immutable object by replacing the {@link Batch2DbQuery.World#getBatchConsumers() batchConsumers} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to replace the batchConsumers map
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutableWorld withBatchConsumers(Map<String, ? extends BatchConsumer> entries) {
    if (this.batchConsumers == entries) return this;
    ImmutableMap<String, BatchConsumer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableWorld(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWorld} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWorld
        && equalsByValue((ImmutableWorld) another);
  }

  private boolean equalsByValue(ImmutableWorld another) {
    return batchConsumers.equals(another.batchConsumers);
  }

  /**
   * Computes a hash code from attributes: {@code batchConsumers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + batchConsumers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code World} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("World")
        .omitNullValues()
        .add("batchConsumers", batchConsumers)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Batch2DbQuery.World} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable World instance
   */
  public static ImmutableWorld copyOf(Batch2DbQuery.World instance) {
    if (instance instanceof ImmutableWorld) {
      return (ImmutableWorld) instance;
    }
    return ImmutableWorld.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWorld ImmutableWorld}.
   * <pre>
   * ImmutableWorld.builder()
   *    .putBatchConsumers|putAllBatchConsumers(String =&gt; io.resys.thena.client.sample.entities.BatchConsumer) // {@link Batch2DbQuery.World#getBatchConsumers() batchConsumers} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableWorld builder
   */
  public static ImmutableWorld.Builder builder() {
    return new ImmutableWorld.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWorld ImmutableWorld}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Batch2DbQuery.World", generator = "Immutables")
  public static final class Builder {
    private ImmutableMap.Builder<String, BatchConsumer> batchConsumers = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code World} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Batch2DbQuery.World instance) {
      Objects.requireNonNull(instance, "instance");
      putAllBatchConsumers(instance.getBatchConsumers());
      return this;
    }

    /**
     * Put one entry to the {@link Batch2DbQuery.World#getBatchConsumers() batchConsumers} map.
     * @param key The key in the batchConsumers map
     * @param value The associated value in the batchConsumers map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBatchConsumers(String key, BatchConsumer value) {
      this.batchConsumers.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Batch2DbQuery.World#getBatchConsumers() batchConsumers} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putBatchConsumers(Map.Entry<String, ? extends BatchConsumer> entry) {
      this.batchConsumers.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Batch2DbQuery.World#getBatchConsumers() batchConsumers} map. Nulls are not permitted
     * @param entries The entries that will be added to the batchConsumers map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder batchConsumers(Map<String, ? extends BatchConsumer> entries) {
      this.batchConsumers = ImmutableMap.builder();
      return putAllBatchConsumers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Batch2DbQuery.World#getBatchConsumers() batchConsumers} map. Nulls are not permitted
     * @param entries The entries that will be added to the batchConsumers map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllBatchConsumers(Map<String, ? extends BatchConsumer> entries) {
      this.batchConsumers.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableWorld ImmutableWorld}.
     * @return An immutable instance of World
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWorld build() {
      return new ImmutableWorld(batchConsumers.build());
    }
  }
}
