package io.resys.thena.client.sample;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.api.entities.BatchLog;
import io.resys.thena.api.entities.BatchStatus;
import io.resys.thena.client.sample.entities.BatchConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Batch2DbBuilder.PersistenceUnit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePersistenceUnit.builder()}.
 */
@Generated(from = "Batch2DbBuilder.PersistenceUnit", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutablePersistenceUnit
    implements Batch2DbBuilder.PersistenceUnit {
  private final ImmutableList<String> commitMessages;
  private final ImmutableList<String> commitAuthors;
  private final ImmutableList<BatchConsumer> batchConsumersInserts;
  private final ImmutableList<BatchConsumer> batchConsumersUpdates;
  private final ImmutableList<BatchConsumer> batchConsumersDeletes;
  private final String tenantId;
  private final BatchStatus status;
  private final String log;
  private final ImmutableList<BatchLog> commitLogs;

  private ImmutablePersistenceUnit(
      ImmutableList<String> commitMessages,
      ImmutableList<String> commitAuthors,
      ImmutableList<BatchConsumer> batchConsumersInserts,
      ImmutableList<BatchConsumer> batchConsumersUpdates,
      ImmutableList<BatchConsumer> batchConsumersDeletes,
      String tenantId,
      BatchStatus status,
      String log,
      ImmutableList<BatchLog> commitLogs) {
    this.commitMessages = commitMessages;
    this.commitAuthors = commitAuthors;
    this.batchConsumersInserts = batchConsumersInserts;
    this.batchConsumersUpdates = batchConsumersUpdates;
    this.batchConsumersDeletes = batchConsumersDeletes;
    this.tenantId = tenantId;
    this.status = status;
    this.log = log;
    this.commitLogs = commitLogs;
  }

  /**
   * @return The value of the {@code commitMessages} attribute
   */
  @Override
  public ImmutableList<String> getCommitMessages() {
    return commitMessages;
  }

  /**
   * @return The value of the {@code commitAuthors} attribute
   */
  @Override
  public ImmutableList<String> getCommitAuthors() {
    return commitAuthors;
  }

  /**
   * @return The value of the {@code batchConsumersInserts} attribute
   */
  @Override
  public ImmutableList<BatchConsumer> getBatchConsumersInserts() {
    return batchConsumersInserts;
  }

  /**
   * @return The value of the {@code batchConsumersUpdates} attribute
   */
  @Override
  public ImmutableList<BatchConsumer> getBatchConsumersUpdates() {
    return batchConsumersUpdates;
  }

  /**
   * @return The value of the {@code batchConsumersDeletes} attribute
   */
  @Override
  public ImmutableList<BatchConsumer> getBatchConsumersDeletes() {
    return batchConsumersDeletes;
  }

  /**
   * @return The value of the {@code tenantId} attribute
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @Override
  public BatchStatus getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code log} attribute
   */
  @Override
  public String getLog() {
    return log;
  }

  /**
   * @return The value of the {@code commitLogs} attribute
   */
  @Override
  public ImmutableList<BatchLog> getCommitLogs() {
    return commitLogs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getCommitMessages() commitMessages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePersistenceUnit withCommitMessages(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        newValue,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getCommitMessages() commitMessages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of commitMessages elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutablePersistenceUnit withCommitMessages(Iterable<String> elements) {
    if (this.commitMessages == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        newValue,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getCommitAuthors() commitAuthors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePersistenceUnit withCommitAuthors(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        newValue,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getCommitAuthors() commitAuthors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of commitAuthors elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutablePersistenceUnit withCommitAuthors(Iterable<String> elements) {
    if (this.commitAuthors == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        newValue,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersInserts() batchConsumersInserts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePersistenceUnit withBatchConsumersInserts(BatchConsumer... elements) {
    ImmutableList<BatchConsumer> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        newValue,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersInserts() batchConsumersInserts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of batchConsumersInserts elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutablePersistenceUnit withBatchConsumersInserts(Iterable<? extends BatchConsumer> elements) {
    if (this.batchConsumersInserts == elements) return this;
    ImmutableList<BatchConsumer> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        newValue,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersUpdates() batchConsumersUpdates}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePersistenceUnit withBatchConsumersUpdates(BatchConsumer... elements) {
    ImmutableList<BatchConsumer> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        newValue,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersUpdates() batchConsumersUpdates}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of batchConsumersUpdates elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutablePersistenceUnit withBatchConsumersUpdates(Iterable<? extends BatchConsumer> elements) {
    if (this.batchConsumersUpdates == elements) return this;
    ImmutableList<BatchConsumer> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        newValue,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersDeletes() batchConsumersDeletes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePersistenceUnit withBatchConsumersDeletes(BatchConsumer... elements) {
    ImmutableList<BatchConsumer> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        newValue,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersDeletes() batchConsumersDeletes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of batchConsumersDeletes elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutablePersistenceUnit withBatchConsumersDeletes(Iterable<? extends BatchConsumer> elements) {
    if (this.batchConsumersDeletes == elements) return this;
    ImmutableList<BatchConsumer> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        newValue,
        this.tenantId,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Batch2DbBuilder.PersistenceUnit#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePersistenceUnit withTenantId(String value) {
    String newValue = Objects.requireNonNull(value, "tenantId");
    if (this.tenantId.equals(newValue)) return this;
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        newValue,
        this.status,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Batch2DbBuilder.PersistenceUnit#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePersistenceUnit withStatus(BatchStatus value) {
    BatchStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status == newValue) return this;
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        newValue,
        this.log,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Batch2DbBuilder.PersistenceUnit#getLog() log} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for log
   * @return A modified copy or the {@code this} object
   */
  public final ImmutablePersistenceUnit withLog(String value) {
    String newValue = Objects.requireNonNull(value, "log");
    if (this.log.equals(newValue)) return this;
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        newValue,
        this.commitLogs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getCommitLogs() commitLogs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePersistenceUnit withCommitLogs(BatchLog... elements) {
    ImmutableList<BatchLog> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Batch2DbBuilder.PersistenceUnit#getCommitLogs() commitLogs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of commitLogs elements to set
   * @return A modified copy or {@code this} if not changed
   */
  public final ImmutablePersistenceUnit withCommitLogs(Iterable<? extends BatchLog> elements) {
    if (this.commitLogs == elements) return this;
    ImmutableList<BatchLog> newValue = ImmutableList.copyOf(elements);
    return new ImmutablePersistenceUnit(
        this.commitMessages,
        this.commitAuthors,
        this.batchConsumersInserts,
        this.batchConsumersUpdates,
        this.batchConsumersDeletes,
        this.tenantId,
        this.status,
        this.log,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePersistenceUnit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePersistenceUnit
        && equalsByValue((ImmutablePersistenceUnit) another);
  }

  private boolean equalsByValue(ImmutablePersistenceUnit another) {
    return commitMessages.equals(another.commitMessages)
        && commitAuthors.equals(another.commitAuthors)
        && batchConsumersInserts.equals(another.batchConsumersInserts)
        && batchConsumersUpdates.equals(another.batchConsumersUpdates)
        && batchConsumersDeletes.equals(another.batchConsumersDeletes)
        && tenantId.equals(another.tenantId)
        && status.equals(another.status)
        && log.equals(another.log)
        && commitLogs.equals(another.commitLogs);
  }

  /**
   * Computes a hash code from attributes: {@code commitMessages}, {@code commitAuthors}, {@code batchConsumersInserts}, {@code batchConsumersUpdates}, {@code batchConsumersDeletes}, {@code tenantId}, {@code status}, {@code log}, {@code commitLogs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + commitMessages.hashCode();
    h += (h << 5) + commitAuthors.hashCode();
    h += (h << 5) + batchConsumersInserts.hashCode();
    h += (h << 5) + batchConsumersUpdates.hashCode();
    h += (h << 5) + batchConsumersDeletes.hashCode();
    h += (h << 5) + tenantId.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + log.hashCode();
    h += (h << 5) + commitLogs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PersistenceUnit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PersistenceUnit")
        .omitNullValues()
        .add("commitMessages", commitMessages)
        .add("commitAuthors", commitAuthors)
        .add("batchConsumersInserts", batchConsumersInserts)
        .add("batchConsumersUpdates", batchConsumersUpdates)
        .add("batchConsumersDeletes", batchConsumersDeletes)
        .add("tenantId", tenantId)
        .add("status", status)
        .add("log", log)
        .add("commitLogs", commitLogs)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Batch2DbBuilder.PersistenceUnit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PersistenceUnit instance
   */
  public static ImmutablePersistenceUnit copyOf(Batch2DbBuilder.PersistenceUnit instance) {
    if (instance instanceof ImmutablePersistenceUnit) {
      return (ImmutablePersistenceUnit) instance;
    }
    return ImmutablePersistenceUnit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePersistenceUnit ImmutablePersistenceUnit}.
   * <pre>
   * ImmutablePersistenceUnit.builder()
   *    .addCommitMessages|addAllCommitMessages(String) // {@link Batch2DbBuilder.PersistenceUnit#getCommitMessages() commitMessages} elements
   *    .addCommitAuthors|addAllCommitAuthors(String) // {@link Batch2DbBuilder.PersistenceUnit#getCommitAuthors() commitAuthors} elements
   *    .addBatchConsumersInserts|addAllBatchConsumersInserts(io.resys.thena.client.sample.entities.BatchConsumer) // {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersInserts() batchConsumersInserts} elements
   *    .addBatchConsumersUpdates|addAllBatchConsumersUpdates(io.resys.thena.client.sample.entities.BatchConsumer) // {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersUpdates() batchConsumersUpdates} elements
   *    .addBatchConsumersDeletes|addAllBatchConsumersDeletes(io.resys.thena.client.sample.entities.BatchConsumer) // {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersDeletes() batchConsumersDeletes} elements
   *    .tenantId(String) // required {@link Batch2DbBuilder.PersistenceUnit#getTenantId() tenantId}
   *    .status(io.resys.thena.api.entities.BatchStatus) // required {@link Batch2DbBuilder.PersistenceUnit#getStatus() status}
   *    .log(String) // required {@link Batch2DbBuilder.PersistenceUnit#getLog() log}
   *    .addCommitLogs|addAllCommitLogs(io.resys.thena.api.entities.BatchLog) // {@link Batch2DbBuilder.PersistenceUnit#getCommitLogs() commitLogs} elements
   *    .build();
   * </pre>
   * @return A new ImmutablePersistenceUnit builder
   */
  public static ImmutablePersistenceUnit.Builder builder() {
    return new ImmutablePersistenceUnit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePersistenceUnit ImmutablePersistenceUnit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Batch2DbBuilder.PersistenceUnit", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TENANT_ID = 0x1L;
    private static final long INIT_BIT_STATUS = 0x2L;
    private static final long INIT_BIT_LOG = 0x4L;
    private long initBits = 0x7L;

    private ImmutableList.Builder<String> commitMessages = ImmutableList.builder();
    private ImmutableList.Builder<String> commitAuthors = ImmutableList.builder();
    private ImmutableList.Builder<BatchConsumer> batchConsumersInserts = ImmutableList.builder();
    private ImmutableList.Builder<BatchConsumer> batchConsumersUpdates = ImmutableList.builder();
    private ImmutableList.Builder<BatchConsumer> batchConsumersDeletes = ImmutableList.builder();
    private String tenantId;
    private BatchStatus status;
    private String log;
    private ImmutableList.Builder<BatchLog> commitLogs = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PersistenceUnit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Batch2DbBuilder.PersistenceUnit instance) {
      Objects.requireNonNull(instance, "instance");
      addAllCommitMessages(instance.getCommitMessages());
      addAllCommitAuthors(instance.getCommitAuthors());
      addAllBatchConsumersInserts(instance.getBatchConsumersInserts());
      addAllBatchConsumersUpdates(instance.getBatchConsumersUpdates());
      addAllBatchConsumersDeletes(instance.getBatchConsumersDeletes());
      this.tenantId(instance.getTenantId());
      this.status(instance.getStatus());
      this.log(instance.getLog());
      addAllCommitLogs(instance.getCommitLogs());
      return this;
    }

    /**
     * Adds one element to {@link Batch2DbBuilder.PersistenceUnit#getCommitMessages() commitMessages} list.
     * @param element A commitMessages element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommitMessages(String element) {
      this.commitMessages.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getCommitMessages() commitMessages} list.
     * @param elements An array of commitMessages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommitMessages(String... elements) {
      this.commitMessages.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Batch2DbBuilder.PersistenceUnit#getCommitMessages() commitMessages} list.
     * @param elements An iterable of commitMessages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitMessages(Iterable<String> elements) {
      this.commitMessages = ImmutableList.builder();
      return addAllCommitMessages(elements);
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getCommitMessages() commitMessages} list.
     * @param elements An iterable of commitMessages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCommitMessages(Iterable<String> elements) {
      this.commitMessages.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Batch2DbBuilder.PersistenceUnit#getCommitAuthors() commitAuthors} list.
     * @param element A commitAuthors element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommitAuthors(String element) {
      this.commitAuthors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getCommitAuthors() commitAuthors} list.
     * @param elements An array of commitAuthors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommitAuthors(String... elements) {
      this.commitAuthors.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Batch2DbBuilder.PersistenceUnit#getCommitAuthors() commitAuthors} list.
     * @param elements An iterable of commitAuthors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitAuthors(Iterable<String> elements) {
      this.commitAuthors = ImmutableList.builder();
      return addAllCommitAuthors(elements);
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getCommitAuthors() commitAuthors} list.
     * @param elements An iterable of commitAuthors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCommitAuthors(Iterable<String> elements) {
      this.commitAuthors.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersInserts() batchConsumersInserts} list.
     * @param element A batchConsumersInserts element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBatchConsumersInserts(BatchConsumer element) {
      this.batchConsumersInserts.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersInserts() batchConsumersInserts} list.
     * @param elements An array of batchConsumersInserts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBatchConsumersInserts(BatchConsumer... elements) {
      this.batchConsumersInserts.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersInserts() batchConsumersInserts} list.
     * @param elements An iterable of batchConsumersInserts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder batchConsumersInserts(Iterable<? extends BatchConsumer> elements) {
      this.batchConsumersInserts = ImmutableList.builder();
      return addAllBatchConsumersInserts(elements);
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersInserts() batchConsumersInserts} list.
     * @param elements An iterable of batchConsumersInserts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBatchConsumersInserts(Iterable<? extends BatchConsumer> elements) {
      this.batchConsumersInserts.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersUpdates() batchConsumersUpdates} list.
     * @param element A batchConsumersUpdates element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBatchConsumersUpdates(BatchConsumer element) {
      this.batchConsumersUpdates.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersUpdates() batchConsumersUpdates} list.
     * @param elements An array of batchConsumersUpdates elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBatchConsumersUpdates(BatchConsumer... elements) {
      this.batchConsumersUpdates.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersUpdates() batchConsumersUpdates} list.
     * @param elements An iterable of batchConsumersUpdates elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder batchConsumersUpdates(Iterable<? extends BatchConsumer> elements) {
      this.batchConsumersUpdates = ImmutableList.builder();
      return addAllBatchConsumersUpdates(elements);
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersUpdates() batchConsumersUpdates} list.
     * @param elements An iterable of batchConsumersUpdates elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBatchConsumersUpdates(Iterable<? extends BatchConsumer> elements) {
      this.batchConsumersUpdates.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersDeletes() batchConsumersDeletes} list.
     * @param element A batchConsumersDeletes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBatchConsumersDeletes(BatchConsumer element) {
      this.batchConsumersDeletes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersDeletes() batchConsumersDeletes} list.
     * @param elements An array of batchConsumersDeletes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBatchConsumersDeletes(BatchConsumer... elements) {
      this.batchConsumersDeletes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersDeletes() batchConsumersDeletes} list.
     * @param elements An iterable of batchConsumersDeletes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder batchConsumersDeletes(Iterable<? extends BatchConsumer> elements) {
      this.batchConsumersDeletes = ImmutableList.builder();
      return addAllBatchConsumersDeletes(elements);
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getBatchConsumersDeletes() batchConsumersDeletes} list.
     * @param elements An iterable of batchConsumersDeletes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBatchConsumersDeletes(Iterable<? extends BatchConsumer> elements) {
      this.batchConsumersDeletes.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Batch2DbBuilder.PersistenceUnit#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tenantId(String tenantId) {
      this.tenantId = Objects.requireNonNull(tenantId, "tenantId");
      initBits &= ~INIT_BIT_TENANT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Batch2DbBuilder.PersistenceUnit#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder status(BatchStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link Batch2DbBuilder.PersistenceUnit#getLog() log} attribute.
     * @param log The value for log 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder log(String log) {
      this.log = Objects.requireNonNull(log, "log");
      initBits &= ~INIT_BIT_LOG;
      return this;
    }

    /**
     * Adds one element to {@link Batch2DbBuilder.PersistenceUnit#getCommitLogs() commitLogs} list.
     * @param element A commitLogs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommitLogs(BatchLog element) {
      this.commitLogs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getCommitLogs() commitLogs} list.
     * @param elements An array of commitLogs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommitLogs(BatchLog... elements) {
      this.commitLogs.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Batch2DbBuilder.PersistenceUnit#getCommitLogs() commitLogs} list.
     * @param elements An iterable of commitLogs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitLogs(Iterable<? extends BatchLog> elements) {
      this.commitLogs = ImmutableList.builder();
      return addAllCommitLogs(elements);
    }

    /**
     * Adds elements to {@link Batch2DbBuilder.PersistenceUnit#getCommitLogs() commitLogs} list.
     * @param elements An iterable of commitLogs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCommitLogs(Iterable<? extends BatchLog> elements) {
      this.commitLogs.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePersistenceUnit ImmutablePersistenceUnit}.
     * @return An immutable instance of PersistenceUnit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePersistenceUnit build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePersistenceUnit(
          commitMessages.build(),
          commitAuthors.build(),
          batchConsumersInserts.build(),
          batchConsumersUpdates.build(),
          batchConsumersDeletes.build(),
          tenantId,
          status,
          log,
          commitLogs.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TENANT_ID) != 0) attributes.add("tenantId");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_LOG) != 0) attributes.add("log");
      return "Cannot build PersistenceUnit, some of required attributes are not set " + attributes;
    }
  }
}
