package io.resys.thena.client.sample;

import io.resys.thena.client.sample.entities.BatchConsumer;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.String;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;

public interface Batch2DbQuery {
  Uni<World> findAll();

  BatchConsumersQuery queryBatchConsumers();

  interface BatchConsumersQuery {
    Uni<List<BatchConsumer>> findAll();

    Uni<BatchConsumer> getById(String id);

    Multi<BatchConsumer> findAllEnabled();

    Uni<List<BatchConsumer>> findAllEnabledByAppId(String appId);

    Uni<List<BatchConsumer>> findAllUsingSqlBuilder(FindAllFilter filter);

    Uni<List<BatchConsumer>> findAllByAppId(String appId, boolean lockForUpdate);
  }

  @Value.Immutable
  interface World {
    Map<String, BatchConsumer> getBatchConsumers();
  }
}
