package io.resys.thena.client.sample;

import io.resys.thena.api.entities.BatchLog;
import io.resys.thena.api.entities.BatchStatus;
import io.resys.thena.client.sample.entities.BatchConsumer;
import io.smallrye.mutiny.Uni;
import java.lang.String;
import java.util.List;
import org.immutables.value.Value;

public interface Batch2DbBuilder {
  Batch2DbBuilder from(PersistenceUnit unit);

  Uni<PersistenceUnit> persist();

  @Value.Immutable
  interface PersistenceUnit {
    List<String> getCommitMessages();

    List<String> getCommitAuthors();

    List<BatchConsumer> getBatchConsumersInserts();

    List<BatchConsumer> getBatchConsumersUpdates();

    List<BatchConsumer> getBatchConsumersDeletes();

    String getTenantId();

    BatchStatus getStatus();

    String getLog();

    List<BatchLog> getCommitLogs();

    default PersistenceUnit merge(List<PersistenceUnit> src) {
      final var builder = ImmutablePersistenceUnit.builder().from(this);
      src.forEach(entry -> entry.merge(builder));
      return builder.build();
    }

    default PersistenceUnit merge(PersistenceUnit src) {
      return merge(ImmutablePersistenceUnit.builder().from(src)).build();
    }

    default ImmutablePersistenceUnit.Builder merge(ImmutablePersistenceUnit.Builder target) {
      return target
        .addAllBatchConsumersInserts(this.getBatchConsumersInserts())
        .addAllBatchConsumersUpdates(this.getBatchConsumersUpdates())
        .addAllBatchConsumersDeletes(this.getBatchConsumersDeletes())
        .addAllCommitLogs(this.getCommitLogs()).addAllCommitMessages(this.getCommitMessages())
        .addAllCommitAuthors(this.getCommitAuthors());
    }
  }
}
