package io.resys.thena.client.sample;

import io.resys.thena.api.entities.Tenant;
import io.resys.thena.spi.TenantDataSource;
import io.smallrye.mutiny.Uni;
import java.lang.FunctionalInterface;
import java.lang.String;

public interface Batch2Db extends TenantDataSource {
  Uni<Batch2Db> withTenant();

  Uni<Batch2Db> withTenant(String tenantId);

  Batch2Db withTenant(Tenant tenant);

  Batch2DbQuery query();

  Batch2DbBuilder builder();

  <R> Uni<R> withTransaction(TenantDataSource.TxScope scope, Transaction<R> callback);

  @FunctionalInterface
  interface Transaction<R> {
    Uni<R> apply(Batch2Db currentState);
  }
}
