/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.netty.buffer.ByteBufInputStream;
import io.resys.thena.jackson.JsonArrayDeserializer;
import io.resys.thena.jackson.JsonObjectDeserializer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.VertxModule;
import io.vertx.core.spi.json.JsonCodec;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class QuarkusJacksonJsonCodec
implements JsonCodec {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static volatile ObjectMapper prettyMapper;

    private ObjectMapper prettyMapper() {
        if (prettyMapper == null) {
            prettyMapper = mapper.copy();
            prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        }
        return prettyMapper;
    }

    public <T> T fromValue(Object json, Class<T> clazz) {
        Object value = mapper.convertValue(json, clazz);
        if (clazz == Object.class) {
            value = QuarkusJacksonJsonCodec.adapt(value);
        }
        return (T)value;
    }

    public <T> T fromString(String str, Class<T> clazz) throws DecodeException {
        return QuarkusJacksonJsonCodec.fromParser(QuarkusJacksonJsonCodec.createParser(str), clazz);
    }

    public <T> T fromBuffer(Buffer buf, Class<T> clazz) throws DecodeException {
        return QuarkusJacksonJsonCodec.fromParser(QuarkusJacksonJsonCodec.createParser(buf), clazz);
    }

    public static JsonParser createParser(Buffer buf) {
        try {
            return mapper.getFactory().createParser((InputStream)new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
    }

    public static JsonParser createParser(String str) {
        try {
            return mapper.getFactory().createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T fromParser(JsonParser parser, Class<T> type) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = mapper.readValue(parser, type);
            remaining = parser.nextToken();
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e);
        }
        finally {
            QuarkusJacksonJsonCodec.close((Closeable)parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type == Object.class) {
            value = QuarkusJacksonJsonCodec.adapt(value);
        }
        return (T)value;
    }

    public String toString(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper = pretty ? this.prettyMapper() : QuarkusJacksonJsonCodec.mapper;
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper = pretty ? this.prettyMapper() : QuarkusJacksonJsonCodec.mapper;
            return Buffer.buffer((byte[])mapper.writeValueAsBytes(object));
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void close(Closeable parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object adapt(Object o) {
        try {
            if (o instanceof List) {
                List list = (List)o;
                return new JsonArray(list);
            }
            if (o instanceof Map) {
                Map map = (Map)o;
                return new JsonObject(map);
            }
            return o;
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode: " + e.getMessage());
        }
    }

    public static ObjectMapper mapper() {
        return mapper;
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        VertxModule module = new VertxModule();
        module.addDeserializer(JsonObject.class, (JsonDeserializer)new JsonObjectDeserializer());
        module.addDeserializer(JsonArray.class, (JsonDeserializer)new JsonArrayDeserializer());
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new GuavaModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

