/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.TxCommand;

public class TransactionImpl
implements Transaction {
    private final ContextInternal context;
    private final Connection connection;
    private final Promise<TxCommand.Kind> completion;
    private final Handler<Void> endHandler;
    private int pendingQueries;
    private boolean ended;
    private boolean failed;
    private TxCommand<?> endCommand;

    TransactionImpl(ContextInternal context, Handler<Void> endHandler, Connection connection) {
        this.context = context;
        this.connection = connection;
        this.completion = context.promise();
        this.endHandler = endHandler;
    }

    Future<Transaction> begin() {
        PromiseInternal promise = this.context.promise();
        TxCommand<TransactionImpl> begin = new TxCommand<TransactionImpl>(TxCommand.Kind.BEGIN, this);
        begin.handler = this.wrap(begin, promise);
        this.schedule(begin);
        return promise.future();
    }

    public void fail() {
        this.failed = true;
    }

    private <R> void execute(CommandBase<R> cmd) {
        Handler handler = cmd.handler;
        this.connection.schedule(this.context, cmd).onComplete(handler);
    }

    private <T> Handler<AsyncResult<T>> wrap(CommandBase<?> cmd, Promise<T> handler) {
        return ar -> {
            CommandBase abc = cmd;
            TransactionImpl transactionImpl = this;
            synchronized (transactionImpl) {
                --this.pendingQueries;
            }
            this.checkEnd();
            handler.handle((AsyncResult)ar);
        };
    }

    public <R> void schedule(CommandBase<R> cmd, Promise<R> handler) {
        cmd.handler = this.wrap(cmd, handler);
        if (!this.schedule(cmd)) {
            handler.fail("Transaction already completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> boolean schedule(CommandBase<R> b) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.ended) {
                return false;
            }
            ++this.pendingQueries;
        }
        this.execute(b);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnd() {
        TxCommand<?> cmd;
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.pendingQueries > 0 || !this.ended || this.endCommand != null) {
                return;
            }
            TxCommand.Kind kind = this.failed ? TxCommand.Kind.ROLLBACK : TxCommand.Kind.COMMIT;
            cmd = this.endCommand = this.txCommand(kind);
        }
        this.endHandler.handle(null);
        this.execute(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<TxCommand.Kind> end(boolean rollback) {
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.endCommand != null) {
                return this.context.failedFuture("Transaction already complete");
            }
            this.ended = true;
            this.failed |= rollback;
        }
        this.checkEnd();
        return this.completion.future();
    }

    @Override
    public Future<Void> commit() {
        return this.end(false).flatMap(k -> {
            if (k == TxCommand.Kind.COMMIT) {
                return Future.succeededFuture();
            }
            return Future.failedFuture(TransactionRollbackException.INSTANCE);
        });
    }

    @Override
    public void commit(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.commit();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<Void> rollback() {
        return this.end(true).mapEmpty();
    }

    @Override
    public void rollback(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.rollback();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    private TxCommand<Void> txCommand(TxCommand.Kind kind) {
        TxCommand<Object> cmd = new TxCommand<Object>(kind, null);
        cmd.handler = ar -> {
            if (ar.succeeded()) {
                this.completion.complete(kind);
            } else {
                this.completion.fail(ar.cause());
            }
        };
        return cmd;
    }

    @Override
    public void completion(Handler<AsyncResult<Void>> handler) {
        this.completion().onComplete(handler);
    }

    @Override
    public Future<Void> completion() {
        return this.completion.future().flatMap(k -> {
            if (k == TxCommand.Kind.COMMIT) {
                return Future.succeededFuture();
            }
            return Future.failedFuture(TransactionRollbackException.INSTANCE);
        });
    }
}

