/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatementImpl;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.impl.TransactionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import io.vertx.sqlclient.impl.pool.SqlConnectionPool;
import io.vertx.sqlclient.impl.tracing.QueryReporter;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import io.vertx.sqlclient.spi.Driver;

public class SqlConnectionBase<C extends SqlConnectionBase<C>>
extends SqlClientBase
implements SqlConnectionInternal,
Closeable {
    private volatile Handler<Throwable> exceptionHandler;
    private volatile Handler<Void> closeHandler;
    private volatile boolean closeFactoryAfterUsage;
    protected TransactionImpl tx;
    protected final ContextInternal context;
    protected final ConnectionFactory factory;
    protected final Connection conn;

    public SqlConnectionBase(ContextInternal context, ConnectionFactory factory, Connection conn, Driver driver) {
        super(driver);
        this.context = context;
        this.factory = factory;
        this.conn = conn;
    }

    public ConnectionFactory factory() {
        return this.factory;
    }

    @Override
    public Connection unwrap() {
        return this.conn;
    }

    public C prepare(String sql, PrepareOptions options, Handler<AsyncResult<PreparedStatement>> handler) {
        Future<PreparedStatement> fut = this.prepare(sql, options);
        if (handler != null) {
            fut.onComplete(handler);
        }
        return (C)this;
    }

    @Override
    public Future<PreparedStatement> prepare(String sql, PrepareOptions options) {
        return this.schedule(this.context, new PrepareStatementCommand(sql, options, true)).compose(cr -> Future.succeededFuture(PreparedStatementImpl.create(this.conn, this.context, cr, this.autoCommit())), err -> {
            if (this.conn.isIndeterminatePreparedStatementError((Throwable)err)) {
                return Future.succeededFuture(PreparedStatementImpl.create(this.conn, this.context, options, sql, this.autoCommit()));
            }
            return Future.failedFuture(err);
        });
    }

    public C prepare(String sql, Handler<AsyncResult<PreparedStatement>> handler) {
        return (C)this.prepare(sql, (PrepareOptions)null, (Handler)handler);
    }

    @Override
    public Future<PreparedStatement> prepare(String sql) {
        return this.prepare(sql, (PrepareOptions)null);
    }

    @Override
    protected ContextInternal context() {
        return this.context;
    }

    @Override
    protected <T> PromiseInternal<T> promise() {
        return this.context.promise();
    }

    @Override
    protected <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        return this.context.promise(handler);
    }

    @Override
    public void handleClosed() {
        Handler<Void> handler = this.closeHandler;
        if (handler != null) {
            this.context.emit(handler);
        }
    }

    @Override
    public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
        if (this.tx != null) {
            PromiseInternal promise = context.promise();
            this.tx.schedule(cmd, promise);
            return promise.future();
        }
        VertxTracer tracer = context.owner().tracer();
        ClientMetrics metrics = this.conn.metrics();
        if (!(this.conn instanceof SqlConnectionPool.PooledConnection) && cmd instanceof QueryCommandBase && (tracer != null || metrics != null)) {
            QueryReporter queryReporter = new QueryReporter(tracer, metrics, context, (QueryCommandBase)cmd, this.conn);
            queryReporter.before();
            return this.conn.schedule(context, cmd).andThen(ar -> queryReporter.after((AsyncResult)ar));
        }
        return this.conn.schedule(context, cmd);
    }

    @Override
    public void handleException(Throwable err) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            this.context.emit(err, handler);
        } else {
            err.printStackTrace();
        }
    }

    @Override
    public boolean isSSL() {
        return this.conn.isSsl();
    }

    @Override
    public DatabaseMetadata databaseMetadata() {
        return this.conn.getDatabaseMetaData();
    }

    public C closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return (C)this;
    }

    public C exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return (C)this;
    }

    @Override
    public Future<Transaction> begin() {
        if (this.tx != null) {
            throw new IllegalStateException();
        }
        this.tx = new TransactionImpl(this.context, v -> {
            this.tx = null;
        }, this.conn);
        return this.tx.begin();
    }

    @Override
    public Transaction transaction() {
        return this.tx;
    }

    @Override
    boolean autoCommit() {
        return this.tx == null;
    }

    @Override
    public void begin(Handler<AsyncResult<Transaction>> handler) {
        Future<Transaction> fut = this.begin();
        fut.onComplete(handler);
    }

    @Override
    public void handleEvent(Object event) {
    }

    @Override
    public Future<Void> close() {
        PromiseInternal<Void> promise = this.promise();
        this.close((Promise<Void>)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.close((Promise<Void>)this.promise(handler));
    }

    @Override
    public void close(Promise<Void> completion) {
        this.doClose(completion);
        if (this.closeFactoryAfterUsage) {
            completion.future().onComplete(v -> this.factory.close(Promise.promise()));
            this.context.removeCloseHook(this);
        }
    }

    private void doClose(Promise<Void> promise) {
        this.context.execute(promise, p -> {
            if (this.tx != null) {
                this.tx.rollback(ar -> this.conn.close(this, (Promise<Void>)p));
                this.tx = null;
            } else {
                this.conn.close(this, (Promise<Void>)p);
            }
        });
    }

    protected static Future<SqlConnection> prepareForClose(ContextInternal ctx, Future<SqlConnection> future) {
        return future.andThen(ar -> {
            if (ar.succeeded()) {
                SqlConnectionBase base = (SqlConnectionBase)ar.result();
                base.closeFactoryAfterUsage = true;
                ctx.addCloseHook(base);
            }
        });
    }
}

