/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.PreparedStatementImpl;
import io.vertx.sqlclient.impl.QueryExecutor;
import io.vertx.sqlclient.impl.QueryResultBuilder;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.TupleInternal;
import java.util.UUID;

public class CursorImpl
implements Cursor {
    private final Connection conn;
    private final PreparedStatementImpl ps;
    private final ContextInternal context;
    private final boolean autoCommit;
    private final TupleInternal params;
    private String id;
    private boolean closed;
    private QueryResultBuilder<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>> result;

    CursorImpl(PreparedStatementImpl ps, Connection conn, ContextInternal context, boolean autoCommit, TupleInternal params) {
        this.ps = ps;
        this.conn = conn;
        this.context = context;
        this.autoCommit = autoCommit;
        this.params = params;
    }

    @Override
    public synchronized boolean hasMore() {
        if (this.result == null) {
            throw new IllegalStateException("No current cursor read");
        }
        return this.result.isSuspended();
    }

    @Override
    public void read(int count, Handler<AsyncResult<RowSet<Row>>> handler) {
        Future<RowSet<Row>> fut = this.read(count);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public synchronized Future<RowSet<Row>> read(int count) {
        PromiseInternal promise = this.context.promise();
        this.ps.withPreparedStatement(this.ps.options(), this.params, ar -> {
            if (ar.succeeded()) {
                PreparedStatement preparedStatement = (PreparedStatement)ar.result();
                QueryExecutor builder = new QueryExecutor(RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
                if (this.id == null) {
                    this.id = UUID.randomUUID().toString();
                    this.result = builder.executeExtendedQuery(this.conn, preparedStatement, this.ps.options(), this.autoCommit, this.params, count, this.id, false, promise);
                    return;
                } else {
                    if (!this.result.isSuspended()) throw new IllegalStateException();
                    this.result = builder.executeExtendedQuery(this.conn, preparedStatement, this.ps.options(), this.autoCommit, this.params, count, this.id, true, promise);
                }
                return;
            } else {
                promise.fail(ar.cause());
            }
        });
        return promise.future();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        this.close((Promise<Void>)this.context.promise(completionHandler));
    }

    @Override
    public synchronized Future<Void> close() {
        PromiseInternal<Void> promise = this.context.promise();
        this.close((Promise<Void>)promise);
        return promise.future();
    }

    private synchronized void close(Promise<Void> promise) {
        if (!this.closed) {
            this.closed = true;
            if (this.id == null) {
                promise.complete();
            } else {
                String id = this.id;
                this.id = null;
                this.result = null;
                this.ps.closeCursor(id, promise);
            }
        }
    }
}

