/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@MutinyGen(value=io.vertx.sqlclient.Transaction.class)
public class Transaction
implements MutinyDelegate {
    public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg<Transaction>(obj -> new Transaction((io.vertx.sqlclient.Transaction)obj), Transaction::getDelegate);
    private final io.vertx.sqlclient.Transaction delegate;

    public Transaction(io.vertx.sqlclient.Transaction delegate) {
        this.delegate = delegate;
    }

    public Transaction(Object delegate) {
        this.delegate = (io.vertx.sqlclient.Transaction)delegate;
    }

    Transaction() {
        this.delegate = null;
    }

    @Override
    public io.vertx.sqlclient.Transaction getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public Uni<Void> commit() {
        return AsyncResultUni.toUni(handler -> this.delegate.commit((Handler<AsyncResult<Void>>)handler));
    }

    public Void commitAndAwait() {
        return this.commit().await().indefinitely();
    }

    public void commitAndForget() {
        this.commit().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> rollback() {
        return AsyncResultUni.toUni(handler -> this.delegate.rollback((Handler<AsyncResult<Void>>)handler));
    }

    public Void rollbackAndAwait() {
        return this.rollback().await().indefinitely();
    }

    public void rollbackAndForget() {
        this.rollback().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> completion() {
        return AsyncResultUni.toUni(handler -> this.delegate.completion((Handler<AsyncResult<Void>>)handler));
    }

    public Void completionAndAwait() {
        return this.completion().await().indefinitely();
    }

    public void completionAndForget() {
        this.completion().subscribe().with(UniHelper.NOOP);
    }

    public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
        return arg != null ? new Transaction(arg) : null;
    }
}

