/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.sqlclient.PreparedQuery;
import io.vertx.mutiny.sqlclient.Query;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.SqlConnection;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.TransactionPropagation;
import java.util.function.Consumer;
import java.util.function.Function;

@MutinyGen(value=io.vertx.sqlclient.Pool.class)
public class Pool
extends SqlClient
implements MutinyDelegate {
    public static final TypeArg<Pool> __TYPE_ARG = new TypeArg<Pool>(obj -> new Pool((io.vertx.sqlclient.Pool)obj), Pool::getDelegate);
    private final io.vertx.sqlclient.Pool delegate;
    static final TypeArg<RowSet<Row>> TYPE_ARG_1 = new TypeArg<RowSet>(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<Row>(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
    static final TypeArg<RowSet<Row>> TYPE_ARG_0 = new TypeArg<RowSet>(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<Row>(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

    public Pool(io.vertx.sqlclient.Pool delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public Pool(Object delegate) {
        super((io.vertx.sqlclient.Pool)delegate);
        this.delegate = (io.vertx.sqlclient.Pool)delegate;
    }

    Pool() {
        super(null);
        this.delegate = null;
    }

    @Override
    public io.vertx.sqlclient.Pool getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pool that = (Pool)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static Pool pool(SqlConnectOptions connectOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool(connectOptions));
        return ret;
    }

    public static Pool pool(SqlConnectOptions database, PoolOptions options) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool(database, options));
        return ret;
    }

    public static Pool pool(Vertx vertx, SqlConnectOptions database, PoolOptions options) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool(vertx.getDelegate(), database, options));
        return ret;
    }

    @CheckReturnValue
    public Uni<SqlConnection> getConnection() {
        return AsyncResultUni.toUni(handler -> this.delegate.getConnection(MutinyHelper.convertHandler(handler, ar -> ar.map(event -> SqlConnection.newInstance(event)))));
    }

    public SqlConnection getConnectionAndAwait() {
        return this.getConnection().await().indefinitely();
    }

    public void getConnectionAndForget() {
        this.getConnection().subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Query<RowSet<Row>> query(String sql) {
        Query<RowSet<Row>> ret = Query.newInstance(this.delegate.query(sql), TYPE_ARG_0);
        return ret;
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        PreparedQuery<RowSet<Row>> ret = PreparedQuery.newInstance(this.delegate.preparedQuery(sql), TYPE_ARG_1);
        return ret;
    }

    @CheckReturnValue
    public <T> Uni<T> withTransaction(final Function<SqlConnection, Uni<T>> function) {
        return AsyncResultUni.toUni(handler -> this.delegate.withTransaction(new Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                return UniHelper.toFuture((Uni)function.apply(SqlConnection.newInstance(arg)));
            }
        }, handler));
    }

    public <T> T withTransactionAndAwait(Function<SqlConnection, Uni<T>> function) {
        return this.withTransaction(function).await().indefinitely();
    }

    public <T> void withTransactionAndForget(Function<SqlConnection, Uni<T>> function) {
        this.withTransaction(function).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <T> Uni<T> withTransaction(TransactionPropagation txPropagation, final Function<SqlConnection, Uni<T>> function) {
        return AsyncResultUni.toUni(handler -> this.delegate.withTransaction(txPropagation, new Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                return UniHelper.toFuture((Uni)function.apply(SqlConnection.newInstance(arg)));
            }
        }, handler));
    }

    public <T> T withTransactionAndAwait(TransactionPropagation txPropagation, Function<SqlConnection, Uni<T>> function) {
        return this.withTransaction(txPropagation, function).await().indefinitely();
    }

    public <T> void withTransactionAndForget(TransactionPropagation txPropagation, Function<SqlConnection, Uni<T>> function) {
        this.withTransaction(txPropagation, function).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <T> Uni<T> withConnection(final Function<SqlConnection, Uni<T>> function) {
        return AsyncResultUni.toUni(handler -> this.delegate.withConnection(new Function<io.vertx.sqlclient.SqlConnection, Future<T>>(){

            @Override
            public Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
                return UniHelper.toFuture((Uni)function.apply(SqlConnection.newInstance(arg)));
            }
        }, handler));
    }

    public <T> T withConnectionAndAwait(Function<SqlConnection, Uni<T>> function) {
        return this.withConnection(function).await().indefinitely();
    }

    public <T> void withConnectionAndForget(Function<SqlConnection, Uni<T>> function) {
        this.withConnection(function).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    @Override
    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @Deprecated
    @Fluent
    private Pool __connectHandler(Handler<SqlConnection> handler) {
        this.delegate.connectHandler(MutinyHelper.convertHandler(handler, event -> SqlConnection.newInstance(event)));
        return this;
    }

    @Deprecated
    public Pool connectHandler(Consumer<SqlConnection> handler) {
        return this.__connectHandler(MutinyHelper.convertConsumer(handler));
    }

    @Deprecated
    @Fluent
    public Pool connectionProvider(final Function<io.vertx.mutiny.core.Context, Uni<SqlConnection>> provider) {
        this.delegate.connectionProvider(new Function<Context, Future<io.vertx.sqlclient.SqlConnection>>(){

            @Override
            public Future<io.vertx.sqlclient.SqlConnection> apply(Context arg) {
                return UniHelper.toFuture(((Uni)provider.apply(io.vertx.mutiny.core.Context.newInstance(arg))).map(x -> x.getDelegate()));
            }
        });
        return this;
    }

    public int size() {
        int ret = this.delegate.size();
        return ret;
    }

    public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
        return arg != null ? new Pool(arg) : null;
    }
}

