/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.support;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class RepoAssert {
    private static final String NAME_PATTERN = "^([a-zA-Z0-9 +_/-]|\\\\\\\\)+";

    public static String isName(String value, Supplier<String> message) {
        RepoAssert.isTrue(value.matches(NAME_PATTERN), () -> (String)message.get() + " => Valid name pattern: '^([a-zA-Z0-9 +_/-]|\\\\\\\\)+'!", new Object[0]);
        return value;
    }

    public static String notEmptyIfDefined(Optional<String> src, Supplier<String> message) {
        if (src == null) {
            return null;
        }
        String object = src.orElseGet(null);
        if (object == null || object.isBlank()) {
            throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
        }
        return object;
    }

    public static <T> T notNullIfDefined(Optional<T> src, Supplier<String> message) {
        if (src == null) {
            return null;
        }
        T object = src.orElseGet(null);
        if (object == null) {
            throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
        }
        return object;
    }

    public static <T> List<T> notEmpty(List<T> object, Supplier<String> message) {
        if (object == null || object.isEmpty()) {
            throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
        }
        return object;
    }

    public static <T, K> Map<T, K> notEmpty(Map<T, K> object, Supplier<String> message) {
        if (object == null || object.isEmpty()) {
            throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
        }
        return object;
    }

    public static String notEmpty(String object, Supplier<String> message) {
        if (object == null || object.isBlank()) {
            throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
        }
        return object;
    }

    public static String notBlank(String object, Supplier<String> message) {
        if (object != null && object.isBlank()) {
            throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
        }
        return object;
    }

    public static <T> T isNull(T object, Supplier<String> message) {
        if (object == null) {
            return object;
        }
        throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
    }

    public static String isEmpty(String object, Supplier<String> message) {
        if (object == null || object.isBlank()) {
            return object;
        }
        throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
    }

    public static <T> T notNull(T object, Supplier<String> message) {
        if (object == null) {
            throw new RepoAssertException(RepoAssert.getMessage(message, new Object[0]));
        }
        return object;
    }

    public static void isTrue(boolean expression, Supplier<String> message, Object ... args) {
        if (!expression) {
            throw new RepoAssertException(RepoAssert.getMessage(message, args));
        }
    }

    private static String getMessage(Supplier<String> supplier, Object ... args) {
        return supplier != null ? supplier.get().formatted(args) : null;
    }

    public static <T> T fail(String message) {
        throw new RepoAssertException(RepoAssert.getMessage(() -> message, new Object[0]));
    }

    public static class RepoAssertException
    extends RuntimeException {
        private static final long serialVersionUID = 4311634600357697485L;

        public RepoAssertException(String msg) {
            super(msg);
        }
    }
}

