/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.spi;

import io.resys.thena.api.actions.TenantActions;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.spi.TenantDataSource;
import io.resys.thena.support.RepoAssert;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import lombok.Generated;

public class TenantQueryImpl
implements TenantActions.TenantQuery {
    private final TenantDataSource state;
    private final Tenant.StructureType type;
    private String id;
    private String rev;

    public TenantQueryImpl(TenantDataSource state) {
        this.state = state;
        this.type = null;
    }

    public TenantQueryImpl(TenantDataSource state, Tenant.StructureType type) {
        this.state = state;
        this.type = type;
    }

    @Override
    public Multi<Tenant> findAll() {
        return this.state.tenant().findAll();
    }

    @Override
    public Uni<Tenant> get() {
        RepoAssert.notEmpty(this.id, () -> "Define id or name!");
        return this.state.tenant().getByNameOrId(this.id);
    }

    @Override
    public Uni<Tenant> delete() {
        return this.get().onItem().transformToUni(repo -> this.state.tenant().delete((Tenant)repo));
    }

    @Generated
    public TenantDataSource state() {
        return this.state;
    }

    @Generated
    public Tenant.StructureType type() {
        return this.type;
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public String rev() {
        return this.rev;
    }

    @Override
    @Generated
    public TenantQueryImpl id(String id) {
        this.id = id;
        return this;
    }

    @Override
    @Generated
    public TenantQueryImpl rev(String rev) {
        this.rev = rev;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantQueryImpl)) {
            return false;
        }
        TenantQueryImpl other = (TenantQueryImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TenantDataSource this$state = this.state();
        TenantDataSource other$state = other.state();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Tenant.StructureType this$type = this.type();
        Tenant.StructureType other$type = other.type();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$rev = this.rev();
        String other$rev = other.rev();
        return !(this$rev == null ? other$rev != null : !this$rev.equals(other$rev));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TenantQueryImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TenantDataSource $state = this.state();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Tenant.StructureType $type = this.type();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $rev = this.rev();
        result = result * 59 + ($rev == null ? 43 : $rev.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TenantQueryImpl(state=" + String.valueOf(this.state()) + ", type=" + String.valueOf((Object)this.type()) + ", id=" + this.id() + ", rev=" + this.rev() + ")";
    }
}

