/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.spi;

import io.resys.thena.api.actions.ImmutableTenantCommitResult;
import io.resys.thena.api.actions.TenantActions;
import io.resys.thena.api.entities.ImmutableTenant;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.api.envelope.ImmutableMessage;
import io.resys.thena.api.envelope.Message;
import io.resys.thena.spi.TenantDataSource;
import io.resys.thena.support.Identifiers;
import io.resys.thena.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantBuilderImpl
implements TenantActions.TenantBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantBuilderImpl.class);
    private final TenantDataSource state;
    private String externalId;
    private String name;
    private Tenant.StructureType type;

    public TenantBuilderImpl(TenantDataSource state, Tenant.StructureType type) {
        this.state = state;
        this.type = type;
    }

    @Override
    public TenantBuilderImpl externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Override
    public TenantActions.TenantBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TenantBuilderImpl name(String name, Tenant.StructureType type) {
        this.name = name;
        this.type = type;
        return this;
    }

    @Override
    public Uni<TenantActions.TenantCommitResult> build() {
        log.debug("Creating repository '{}' of type {}.", (Object)this.name, (Object)this.type);
        RepoAssert.notEmpty(this.name, () -> "repo name not defined!");
        RepoAssert.notNull(this.type, () -> "type name not defined!");
        RepoAssert.isName(this.name, () -> "repo name has invalid characters!");
        return this.state.tenant().getByName(this.name).onItem().transformToUni(existing -> {
            Uni<Object> result;
            if (existing != null) {
                log.error("Existing repository found with name '{}'", (Object)this.name);
                result = Uni.createFrom().item(ImmutableTenantCommitResult.builder().status(TenantActions.CommitStatus.CONFLICT).addMessages(this.nameNotUnique(existing.getName(), existing.getId())).build());
            } else {
                result = this.state.tenant().findAll().collect().asList().onItem().transformToUni(allRepos -> {
                    String codeName = this.name.toUpperCase();
                    String prefixStart = codeName.substring(0, Math.min(codeName.length(), 10));
                    String prefix = prefixStart.replace("-", "_") + (allRepos.size() + 10) + "_";
                    ImmutableTenant newRepo = ImmutableTenant.builder().id(Identifiers.uuid()).rev(Identifiers.uuid()).type(this.type).name(this.name).externalId(this.externalId).prefix(prefix).build();
                    return this.state.tenant().insert(newRepo).onItem().transform(next -> ImmutableTenantCommitResult.builder().repo((Tenant)next).status(TenantActions.CommitStatus.OK).build());
                });
            }
            return result;
        });
    }

    private Message nameNotUnique(String name, String id) {
        return ImmutableMessage.builder().text("Repo with name: '" + name + "' already exists," + " id: '" + id + "'" + "!").build();
    }

    @Generated
    public TenantBuilderImpl(TenantDataSource state) {
        this.state = state;
    }
}

