/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.spi;

import io.resys.thena.api.actions.TenantActions;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.spi.TenantBuilderImpl;
import io.resys.thena.spi.TenantDataSource;
import io.resys.thena.spi.TenantQueryImpl;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;

public class TenantActionsImpl
implements TenantActions {
    private final TenantDataSource state;
    private final Tenant.StructureType type;

    public TenantActionsImpl(TenantDataSource state, Tenant.StructureType type) {
        this.state = state;
        this.type = type;
    }

    public TenantActionsImpl(TenantDataSource state) {
        this.state = state;
        this.type = null;
    }

    @Override
    public TenantActions.TenantQuery find() {
        return new TenantQueryImpl(this.state, this.type);
    }

    @Override
    public TenantActions.TenantBuilder commit() {
        return new TenantBuilderImpl(this.state, this.type);
    }

    @Override
    public Uni<Void> delete() {
        Multi<Tenant> existingRepos = this.find().findAll();
        return existingRepos.onItem().transformToUni(repo -> {
            String repoId = repo.getId();
            String rev = repo.getRev();
            return this.find().id(repoId).rev(rev).delete();
        }).concatenate().collect().asList().onItem().transformToUni(junk -> this.state.tenant().delete());
    }
}

