/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.spi;

import io.resys.thena.api.entities.Tenant;
import io.resys.thena.api.registry.TenantRegistry;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.resys.thena.registry.TenantRegistrySqlImpl;
import io.resys.thena.spi.TenantDataSource;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.RowIterator;
import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalTenantQueryImpl
implements TenantDataSource.InternalTenantQuery {
    @Generated
    private static final Logger log = LoggerFactory.getLogger("io.resys.thena.show_sql");
    protected final ThenaSqlDataSource dataSource;
    protected final TenantRegistry registry;

    public InternalTenantQueryImpl(ThenaSqlDataSource dataSource) {
        this.dataSource = dataSource;
        this.registry = new TenantRegistrySqlImpl(dataSource.getRegistry());
    }

    public ThenaSqlClient getClient() {
        return this.dataSource.getClient();
    }

    @Override
    public Uni<Tenant> getByName(String name) {
        Optional<Tenant> cached = this.dataSource.getTenantCache().getTenant(name);
        if (cached.isPresent()) {
            return Uni.createFrom().item(cached.get());
        }
        ThenaSqlClient.SqlTuple sql = this.registry.getByName(name);
        if (log.isDebugEnabled()) {
            log.debug("Repo by name query, with props: {} \r\n{}", (Object)sql.getProps().deepToString(), (Object)sql.getValue());
        }
        return this.getClient().preparedQuery(sql.getValue()).mapping(this.registry.defaultMapper()).execute(sql.getProps()).onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (((RowIterator)it).hasNext()) {
                return (Tenant)((RowIterator)it).next();
            }
            return null;
        }).onFailure(e -> this.dataSource.getErrorHandler().notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.dataSource.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't find 'REPOS' by 'name'!", sql, (Throwable)e)));
    }

    @Override
    public Uni<Tenant> getByNameOrId(String nameOrId) {
        Optional<Tenant> cached = this.dataSource.getTenantCache().getTenant(nameOrId);
        if (cached.isPresent()) {
            return Uni.createFrom().item(cached.get());
        }
        ThenaSqlClient.SqlTuple sql = this.registry.getByNameOrId(nameOrId);
        if (log.isDebugEnabled()) {
            log.debug("Repo by nameOrId query, with props: {} \r\n{}", (Object)sql.getProps().deepToString(), (Object)sql.getValue());
        }
        return this.getClient().preparedQuery(sql.getValue()).mapping(this.registry.defaultMapper()).execute(sql.getProps()).onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (((RowIterator)it).hasNext()) {
                return (Tenant)((RowIterator)it).next();
            }
            return null;
        }).onItem().invoke(tenant -> this.dataSource.getTenantCache().setTenant((Tenant)tenant)).onFailure(e -> this.dataSource.getErrorHandler().notFound((Throwable)e)).recoverWithNull().onFailure().invoke(e -> this.dataSource.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't find 'REPOS' by 'name' or 'id'!", sql, (Throwable)e)));
    }

    @Override
    public Uni<Optional<Tenant>> findByNameOrId(String nameOrId) {
        Optional<Tenant> cached = this.dataSource.getTenantCache().getTenant(nameOrId);
        if (cached.isPresent()) {
            return Uni.createFrom().item(Optional.of(cached.get()));
        }
        ThenaSqlClient.SqlTuple sql = this.registry.getByNameOrId(nameOrId);
        if (log.isDebugEnabled()) {
            log.debug("Find tenant by nameOrId query, with props: {} \r\n{}", (Object)sql.getProps().deepToString(), (Object)sql.getValue());
        }
        return this.getClient().preparedQuery(sql.getValue()).mapping(this.registry.defaultMapper()).execute(sql.getProps()).onItem().transform(rowset -> {
            Iterator it = rowset.iterator();
            if (((RowIterator)it).hasNext()) {
                return Optional.of((Tenant)((RowIterator)it).next());
            }
            return Optional.empty();
        }).onItem().invoke(tenant -> {
            if (tenant.isPresent()) {
                this.dataSource.getTenantCache().setTenant((Tenant)tenant.get());
            }
        }).onFailure(e -> this.dataSource.getErrorHandler().notFound((Throwable)e)).recoverWithItem(Optional.empty()).onFailure().invoke(e -> this.dataSource.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlTupleFailed("Can't find 'REPOS' by 'name' or 'id'!", sql, (Throwable)e)));
    }

    @Override
    public Multi<Tenant> findAll() {
        ThenaSqlClient.Sql sql = this.registry.findAll();
        if (log.isDebugEnabled()) {
            log.debug("Fina all tenants query, with props: {} \r\n{}", (Object)"", (Object)sql.getValue());
        }
        return this.getClient().preparedQuery(sql.getValue()).mapping(this.registry.defaultMapper()).execute().onItem().transformToMulti(rowset -> Multi.createFrom().iterable(rowset)).onItem().invoke(newTenant -> this.dataSource.getTenantCache().setTenant((Tenant)newTenant)).onFailure(e -> this.dataSource.getErrorHandler().notFound((Throwable)e)).recoverWithCompletion().onFailure().invoke(e -> this.dataSource.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlFailed("Can't find 'REPOS'!", sql, (Throwable)e)));
    }

    @Override
    public Uni<Void> delete() {
        ThenaSqlClient.Sql tenantDelete = this.registry.dropTable();
        ThenaSqlClient.ThenaSqlPool pool = this.dataSource.getPool();
        return pool.query(tenantDelete.getValue()).execute().onItem().transformToUni(rowSet -> {
            this.dataSource.getTenantCache().invalidateAll();
            return Uni.createFrom().voidItem();
        }).onFailure().invoke(e -> this.dataSource.getErrorHandler().deadEnd(new ThenaSqlDataSourceErrorHandler.SqlSchemaFailed("Can't drop tenant table!", tenantDelete.getValue(), (Throwable)e)));
    }
}

