/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.registry;

import io.resys.thena.api.entities.ImmutableTenant;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.api.registry.TenantRegistry;
import io.resys.thena.datasource.ImmutableSql;
import io.resys.thena.datasource.ImmutableSqlTuple;
import io.resys.thena.datasource.TenantContext;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.storesql.support.SqlStatement;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.function.Function;
import lombok.Generated;

public class TenantRegistrySqlImpl
implements TenantRegistry {
    private final TenantContext options;

    @Override
    public ThenaSqlClient.SqlTuple exists() {
        return ImmutableSqlTuple.builder().value(new SqlStatement().ln().append("SELECT EXISTS").ln().append("(").ln().append("  SELECT table_name").ln().append("  FROM information_schema.tables").ln().append("  WHERE table_name = ?1").ln().append(")").ln().build()).props(Tuple.of(this.options.getTenant())).build();
    }

    @Override
    public ThenaSqlClient.Sql findAll() {
        return ImmutableSql.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getTenant()).build()).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple getByName(String name) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getTenant()).append(" WHERE name = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of(name)).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple getByNameOrId(String name) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getTenant()).append(" WHERE name = $1 OR id = $1 OR external_id = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of(name)).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple insertOne(Tenant newRepo) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("INSERT INTO ").append(this.options.getTenant()).append(" (id, rev, prefix, name, type, external_id) VALUES($1, $2, $3, $4, $5, $6)").build()).props(Tuple.of(newRepo.getId(), newRepo.getRev(), newRepo.getPrefix(), newRepo.getName(), (Object)newRepo.getType(), newRepo.getExternalId())).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple deleteOne(Tenant newRepo) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("DELETE FROM ").append(this.options.getTenant()).append(" WHERE id = $1").build()).props(Tuple.of(newRepo.getId())).build();
    }

    @Override
    public ThenaSqlClient.SqlTuple getById(String id) {
        return ImmutableSqlTuple.builder().value(new SqlStatement().append("SELECT * FROM ").append(this.options.getTenant()).append(" WHERE id = $1").append(" FETCH FIRST ROW ONLY").build()).props(Tuple.of(id)).build();
    }

    @Override
    public Function<Row, Tenant> defaultMapper() {
        return TenantRegistrySqlImpl::repo;
    }

    private static Tenant repo(Row row) {
        return ImmutableTenant.builder().id(row.getString("id")).rev(row.getString("rev")).name(row.getString("name")).externalId(row.getString("external_id")).type(Tenant.StructureType.valueOf(row.getString("type"))).prefix(row.getString("prefix")).build();
    }

    @Override
    public ThenaSqlClient.Sql createTable() {
        return ImmutableSql.builder().value(new SqlStatement().append("CREATE TABLE IF NOT EXISTS ").append(this.options.getTenant()).ln().append("(").ln().append("  id VARCHAR(40) PRIMARY KEY,").ln().append("  rev VARCHAR(40) NOT NULL,").ln().append("  prefix VARCHAR(40) NOT NULL,").ln().append("  type VARCHAR(40) NOT NULL,").ln().append("  name VARCHAR(255) NOT NULL,").ln().append("  external_id VARCHAR(255),").ln().append("  UNIQUE(name), UNIQUE(rev), UNIQUE(prefix), UNIQUE(external_id)").ln().append(");").ln().append("CREATE INDEX IF NOT EXISTS ").append(this.options.getTenant()).append("_NAME_INDEX").append(" ON ").append(this.options.getTenant()).append(" (name);").ln().append("CREATE INDEX IF NOT EXISTS ").append(this.options.getTenant()).append("_EXT_INDEX").append(" ON ").append(this.options.getTenant()).append(" (external_id);").ln().build()).build();
    }

    @Override
    public ThenaSqlClient.Sql createConstraints() {
        return ImmutableSql.builder().value("").build();
    }

    @Override
    public ThenaSqlClient.Sql dropTable() {
        return ImmutableSql.builder().value(new SqlStatement().append("DROP TABLE IF EXISTS ").append(this.options.getTenant()).append(";").ln().build()).build();
    }

    @Generated
    public TenantRegistrySqlImpl(TenantContext options) {
        this.options = options;
    }
}

