/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.model;

import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.processor.model.AnnotationParser;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.support.NamingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;

public final class Metamodel {
    private final List<RegistryMetamodel> registries;
    private final List<TableMetamodel> tables;

    public static MetaModelBuilder builder(ProcessingEnvironment processingEnv) {
        return new MetaModelBuilder(processingEnv);
    }

    public List<TableMetamodel> getTablesForRegistry(RegistryMetamodel registry) {
        String registryPackage = registry.getPackageName();
        return this.tables.stream().filter(table -> {
            String tablePackage = table.getPackageName();
            return tablePackage.equals(registryPackage) || tablePackage.startsWith(registryPackage + ".");
        }).collect(Collectors.toList());
    }

    public RegistryMetamodel findRegistryForTable(TableMetamodel table) {
        String tablePackage = table.getPackageName();
        return this.registries.stream().filter(registry -> {
            String registryPackage = registry.getPackageName();
            return tablePackage.equals(registryPackage) || tablePackage.startsWith(registryPackage + ".");
        }).findFirst().orElse(null);
    }

    @Generated
    public Metamodel(List<RegistryMetamodel> registries, List<TableMetamodel> tables) {
        this.registries = registries;
        this.tables = tables;
    }

    @Generated
    public List<RegistryMetamodel> getRegistries() {
        return this.registries;
    }

    @Generated
    public List<TableMetamodel> getTables() {
        return this.tables;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metamodel)) {
            return false;
        }
        Metamodel other = (Metamodel)o;
        List<RegistryMetamodel> this$registries = this.getRegistries();
        List<RegistryMetamodel> other$registries = other.getRegistries();
        if (this$registries == null ? other$registries != null : !((Object)this$registries).equals(other$registries)) {
            return false;
        }
        List<TableMetamodel> this$tables = this.getTables();
        List<TableMetamodel> other$tables = other.getTables();
        return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RegistryMetamodel> $registries = this.getRegistries();
        result = result * 59 + ($registries == null ? 43 : ((Object)$registries).hashCode());
        List<TableMetamodel> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Metamodel(registries=" + String.valueOf(this.getRegistries()) + ", tables=" + String.valueOf(this.getTables()) + ")";
    }

    public static class MetaModelBuilder {
        private final ProcessingEnvironment processingEnv;
        private final List<RegistryMetamodel> registries = new ArrayList<RegistryMetamodel>();
        private final List<TableMetamodel> tables = new ArrayList<TableMetamodel>();

        public MetaModelBuilder(ProcessingEnvironment processingEnv) {
            this.processingEnv = processingEnv;
        }

        public MetaModelBuilder addAllRegistries(Set<? extends Element> registryElements) {
            for (Element element : registryElements) {
                try {
                    RegistryMetamodel registry = this.extractRegistryConfig(element);
                    if (registry == null) continue;
                    this.registries.add(registry);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Extracted registry: " + registry.getName() + " from package " + registry.getPackageName());
                }
                catch (Exception e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to extract registry from " + String.valueOf(element) + ": " + e.getMessage(), element);
                }
            }
            return this;
        }

        public MetaModelBuilder addAllTables(Set<? extends Element> tableElements) {
            for (Element element : tableElements) {
                try {
                    TableMetamodel table = this.extractTableModel(element);
                    if (table == null) continue;
                    this.tables.add(table);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Extracted table: " + table.getTableName() + " from interface " + table.getInterfaceName());
                }
                catch (Exception e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to extract table from " + String.valueOf(element) + ": " + e.getMessage(), element);
                }
            }
            return this;
        }

        public Metamodel build() {
            for (TableMetamodel table : this.tables) {
                RegistryMetamodel registry = this.findRegistryForTable(table);
                if (registry != null) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Table " + table.getTableName() + " has no corresponding registry in package hierarchy");
            }
            return new Metamodel(this.registries, this.tables);
        }

        private RegistryMetamodel extractRegistryConfig(Element element) {
            if (element.getKind() != ElementKind.PACKAGE) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@TenantSql.Registry can only be applied to packages (via package-info.java)", element);
                return null;
            }
            PackageElement packageElement = (PackageElement)element;
            TenantSql.Registry annotation = element.getAnnotation(TenantSql.Registry.class);
            String packageName = packageElement.getQualifiedName().toString();
            if (packageName == null) {
                return null;
            }
            String worldName = annotation.worldName() != null && !annotation.worldName().isEmpty() ? annotation.worldName() : "World";
            String domainName = NamingUtils.toCamelCaseCapitalized(annotation.name().toLowerCase());
            return RegistryMetamodel.builder().name(domainName).tenantType(annotation.tenantType().name()).tableClassName(domainName + "TableNames").registryClassName(domainName + "Registry").transactionContainerClassName(domainName + "TransactionContainer").transactionSaveClassName(domainName + "SaveTransaction").internalTenantQueryClassName(domainName + "DbInternalTenantQuery").worldName(worldName).packageName(packageName).element(element).nonTenantTables(List.of(annotation.nonTenantTables())).build();
        }

        private TableMetamodel extractTableModel(Element element) {
            if (element.getKind() != ElementKind.INTERFACE) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Skipping expecting interface but got " + String.valueOf((Object)element.getKind()) + ": " + String.valueOf(element.getSimpleName()), element);
                return null;
            }
            AnnotationParser modelExtractor = new AnnotationParser(this.processingEnv);
            return modelExtractor.extract((TypeElement)element);
        }

        private RegistryMetamodel findRegistryForTable(TableMetamodel table) {
            String tablePackage = table.getPackageName();
            return this.registries.stream().filter(registry -> {
                String registryPackage = registry.getPackageName();
                return tablePackage.equals(registryPackage) || tablePackage.startsWith(registryPackage + ".");
            }).findFirst().orElse(null);
        }
    }
}

