/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import io.resys.thena.api.annotations.TenantSql;
import io.resys.thena.processor.model.TableMetamodel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class AnnotationParser {
    private static final Pattern TABLE_NAME_PATTERN = Pattern.compile("\\{([a-zA-Z_][a-zA-Z0-9_]*)\\}");
    private final ProcessingEnvironment processingEnv;

    public AnnotationParser(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public TableMetamodel extract(TypeElement interfaceElement) {
        TenantSql.Table tableAnnotation = interfaceElement.getAnnotation(TenantSql.Table.class);
        String interfaceName = interfaceElement.getSimpleName().toString();
        String packageName = this.processingEnv.getElementUtils().getPackageOf(interfaceElement).getQualifiedName().toString();
        String implClassName = interfaceName + "Impl";
        String tableName = tableAnnotation.name();
        ArrayList<TableMetamodel.SqlMethod> sqlMethods = new ArrayList<TableMetamodel.SqlMethod>();
        for (Element element : interfaceElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (method.getAnnotation(TenantSql.Find.class) != null) {
                sqlMethods.add(this.extractFindMethod(method));
                continue;
            }
            if (method.getAnnotation(TenantSql.FindAll.class) != null) {
                sqlMethods.add(this.extractFindAllMethod(method));
                continue;
            }
            if (method.getAnnotation(TenantSql.Insert.class) != null) {
                sqlMethods.add(this.extractInsertMethod(method));
                continue;
            }
            if (method.getAnnotation(TenantSql.InsertAll.class) != null) {
                sqlMethods.add(this.extractInsertAllMethod(method));
                continue;
            }
            if (method.getAnnotation(TenantSql.Update.class) != null) {
                sqlMethods.add(this.extractUpdateMethod(method));
                continue;
            }
            if (method.getAnnotation(TenantSql.UpdateAll.class) != null) {
                sqlMethods.add(this.extractUpdateAllMethod(method));
                continue;
            }
            if (method.getAnnotation(TenantSql.Delete.class) != null) {
                sqlMethods.add(this.extractDeleteMethod(method));
                continue;
            }
            if (method.getAnnotation(TenantSql.DeleteAll.class) == null) continue;
            sqlMethods.add(this.extractDeleteAllMethod(method));
        }
        sqlMethods.addAll(this.generateLifecycleMethods(tableAnnotation));
        return TableMetamodel.builder().interfaceName(interfaceName).packageName(packageName).implClassName(implClassName).tableName(tableName).order(tableAnnotation.order()).ddlSql(tableAnnotation.ddl()).constraintsSql(tableAnnotation.constraints()).dropSql(tableAnnotation.drop()).sqlMethods(sqlMethods).build();
    }

    private TableMetamodel.SqlMethod extractFindMethod(ExecutableElement method) {
        TenantSql.Find annotation = method.getAnnotation(TenantSql.Find.class);
        String sql = annotation.sql();
        return TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.SELECT).methodName(method.getSimpleName().toString()).sqlTemplate(sql).resolvedSql(sql).mapperClassName(this.extractRowMapperClassName(annotation)).parameters(this.extractParameters(method)).returnType(this.extractEntityTypeFromMapper(annotation)).wrapperType(this.extractWrapperType(method.getReturnType())).propsType(this.determinePropsType(method)).tableNames(this.extractTableNames(sql)).optional(annotation.optional()).sqlBuilderClassName(this.extractSqlBuilderClassName(annotation)).build();
    }

    private TableMetamodel.SqlMethod extractFindAllMethod(ExecutableElement method) {
        TenantSql.FindAll annotation = method.getAnnotation(TenantSql.FindAll.class);
        String sql = annotation.sql();
        boolean isMultiWrapper = annotation.wrapper() == TenantSql.WrapperType.MULTI;
        return TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.SELECT_ALL).methodName(method.getSimpleName().toString()).sqlTemplate(sql).resolvedSql(sql).mapperClassName(this.extractRowMapperClassName(annotation)).parameters(this.extractParameters(method)).returnType(this.extractEntityTypeFromMapper(annotation)).wrapperType(this.extractWrapperType(method.getReturnType())).propsType(this.determinePropsType(method)).tableNames(this.extractTableNames(sql)).multiWrapper(isMultiWrapper).sqlBuilderClassName(this.extractSqlBuilderClassName(annotation)).build();
    }

    private String extractRowMapperClassName(TenantSql.Find mapperClass) {
        try {
            return mapperClass.rowMapper().getName();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }

    private String extractRowMapperClassName(TenantSql.FindAll mapperClass) {
        try {
            return mapperClass.rowMapper().getName();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }

    private TypeName extractEntityTypeFromMapper(TenantSql.Find annotation) {
        try {
            annotation.rowMapper();
            return null;
        }
        catch (MirroredTypeException e) {
            return this.extractGenericFromRowMapper(e.getTypeMirror());
        }
    }

    private TypeName extractEntityTypeFromMapper(TenantSql.FindAll annotation) {
        try {
            annotation.rowMapper();
            return null;
        }
        catch (MirroredTypeException e) {
            return this.extractGenericFromRowMapper(e.getTypeMirror());
        }
    }

    private TypeName extractGenericFromRowMapper(TypeMirror mapperType) {
        if (mapperType instanceof DeclaredType) {
            for (TypeMirror typeMirror : this.processingEnv.getTypeUtils().directSupertypes(mapperType)) {
                DeclaredType interfaceDeclared;
                List<? extends TypeMirror> typeArgs;
                if (!(typeMirror instanceof DeclaredType) || (typeArgs = (interfaceDeclared = (DeclaredType)typeMirror).getTypeArguments()).isEmpty()) continue;
                return TypeName.get(typeArgs.get(0));
            }
        }
        return null;
    }

    private TableMetamodel.SqlMethod extractInsertMethod(ExecutableElement method) {
        TenantSql.Insert annotation = method.getAnnotation(TenantSql.Insert.class);
        String sql = annotation.sql();
        return TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.INSERT).methodName(method.getSimpleName().toString()).sqlTemplate(sql).resolvedSql(sql).mapperClassName(this.extractPropsMapperClassName(annotation)).parameters(this.extractParameters(method)).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL_TUPLE).tableNames(this.extractTableNames(sql)).build();
    }

    private String extractPropsMapperClassName(TenantSql.Insert annotation) {
        try {
            return annotation.propsMapper().getName();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }

    private TableMetamodel.SqlMethod extractInsertAllMethod(ExecutableElement method) {
        TenantSql.InsertAll annotation = method.getAnnotation(TenantSql.InsertAll.class);
        String sql = annotation.sql();
        return TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.INSERT_ALL).methodName(method.getSimpleName().toString()).sqlTemplate(sql).resolvedSql(sql).mapperClassName(this.extractPropsMapperClassName(annotation)).parameters(this.extractParameters(method)).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL_TUPLE_LIST).tableNames(this.extractTableNames(sql)).build();
    }

    private String extractPropsMapperClassName(TenantSql.InsertAll annotation) {
        try {
            annotation.propsMapper();
            return null;
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }

    private TableMetamodel.SqlMethod extractUpdateMethod(ExecutableElement method) {
        TenantSql.Update annotation = method.getAnnotation(TenantSql.Update.class);
        String sql = annotation.sql();
        return TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.UPDATE).methodName(method.getSimpleName().toString()).sqlTemplate(sql).resolvedSql(sql).mapperClassName(this.extractPropsMapperClassName(annotation)).parameters(this.extractParameters(method)).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL_TUPLE).tableNames(this.extractTableNames(sql)).build();
    }

    private String extractPropsMapperClassName(TenantSql.Update annotation) {
        try {
            annotation.propsMapper();
            return null;
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }

    private TableMetamodel.SqlMethod extractUpdateAllMethod(ExecutableElement method) {
        TenantSql.UpdateAll annotation = method.getAnnotation(TenantSql.UpdateAll.class);
        String sql = annotation.sql();
        return TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.UPDATE_ALL).methodName(method.getSimpleName().toString()).sqlTemplate(sql).resolvedSql(sql).mapperClassName(this.extractPropsMapperClassName(annotation)).parameters(this.extractParameters(method)).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL_TUPLE_LIST).tableNames(this.extractTableNames(sql)).build();
    }

    private String extractPropsMapperClassName(TenantSql.UpdateAll annotation) {
        try {
            annotation.propsMapper();
            return null;
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }

    private TableMetamodel.SqlMethod extractDeleteMethod(ExecutableElement method) {
        TenantSql.Delete annotation = method.getAnnotation(TenantSql.Delete.class);
        String sql = annotation.sql();
        return TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.DELETE).methodName(method.getSimpleName().toString()).sqlTemplate(sql).resolvedSql(sql).mapperClassName(this.extractPropsMapperClassName(annotation)).parameters(this.extractParameters(method)).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL_TUPLE).tableNames(this.extractTableNames(sql)).build();
    }

    private String extractPropsMapperClassName(TenantSql.Delete annotation) {
        try {
            annotation.propsMapper();
            return null;
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }

    private TableMetamodel.SqlMethod extractDeleteAllMethod(ExecutableElement method) {
        TenantSql.DeleteAll annotation = method.getAnnotation(TenantSql.DeleteAll.class);
        String sql = annotation.sql();
        return TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.DELETE_ALL).methodName(method.getSimpleName().toString()).sqlTemplate(sql).resolvedSql(sql).mapperClassName(this.extractPropsMapperClassName(annotation)).parameters(this.extractParameters(method)).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL_TUPLE_LIST).tableNames(this.extractTableNames(sql)).build();
    }

    private String extractPropsMapperClassName(TenantSql.DeleteAll annotation) {
        try {
            annotation.propsMapper();
            return null;
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
    }

    private List<TableMetamodel.SqlMethod> generateLifecycleMethods(TenantSql.Table annotation) {
        ArrayList<TableMetamodel.SqlMethod> methods = new ArrayList<TableMetamodel.SqlMethod>();
        if (!annotation.ddl().isEmpty()) {
            methods.add(TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.CREATE_TABLE).methodName("createTable").sqlTemplate(annotation.ddl()).resolvedSql(annotation.ddl()).mapperClassName(null).parameters(List.of()).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL).tableNames(this.extractTableNames(annotation.ddl())).build());
        }
        if (!annotation.constraints().isEmpty()) {
            methods.add(TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.CREATE_CONSTRAINTS).methodName("createConstraints").sqlTemplate(annotation.constraints()).resolvedSql(annotation.constraints()).mapperClassName(null).parameters(List.of()).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL).tableNames(this.extractTableNames(annotation.constraints())).build());
        }
        if (!annotation.drop().isEmpty()) {
            methods.add(TableMetamodel.SqlMethod.builder().type(TableMetamodel.SqlMethodType.DROP_TABLE).methodName("dropTable").sqlTemplate(annotation.drop()).resolvedSql(annotation.drop()).mapperClassName(null).parameters(List.of()).returnType(null).wrapperType(null).propsType(TableMetamodel.SqlPropsType.SQL).tableNames(this.extractTableNames(annotation.drop())).build());
        }
        return methods;
    }

    private List<TableMetamodel.MethodParameter> extractParameters(ExecutableElement method) {
        ArrayList<TableMetamodel.MethodParameter> parameters = new ArrayList<TableMetamodel.MethodParameter>();
        int position = 0;
        for (VariableElement variableElement : method.getParameters()) {
            parameters.add(TableMetamodel.MethodParameter.builder().name(variableElement.getSimpleName().toString()).type(TypeName.get(variableElement.asType())).position(position++).build());
        }
        return parameters;
    }

    private TypeName extractWrapperType(TypeMirror returnType) {
        if (returnType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)returnType;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            String qualifiedName = typeElement.getQualifiedName().toString();
            if (qualifiedName.equals("io.smallrye.mutiny.Uni")) {
                return ClassName.get("io.smallrye.mutiny", "Uni", new String[0]);
            }
            if (qualifiedName.equals("io.smallrye.mutiny.Multi")) {
                return ClassName.get("io.smallrye.mutiny", "Multi", new String[0]);
            }
        }
        return null;
    }

    private TableMetamodel.SqlPropsType determinePropsType(ExecutableElement method) {
        DeclaredType declaredType;
        TypeElement typeElement;
        String qualifiedName;
        List<? extends VariableElement> params = method.getParameters();
        if (params.isEmpty()) {
            return TableMetamodel.SqlPropsType.SQL;
        }
        TypeMirror firstParamType = params.get(0).asType();
        if (firstParamType instanceof DeclaredType && ((qualifiedName = (typeElement = (TypeElement)(declaredType = (DeclaredType)firstParamType).asElement()).getQualifiedName().toString()).equals("java.util.Collection") || qualifiedName.equals("java.util.List") || qualifiedName.equals("java.util.Set"))) {
            return TableMetamodel.SqlPropsType.SQL_TUPLE_LIST;
        }
        return TableMetamodel.SqlPropsType.SQL_TUPLE;
    }

    private List<String> extractTableNames(String sql) {
        ArrayList<String> tableNames = new ArrayList<String>();
        Matcher matcher = TABLE_NAME_PATTERN.matcher(sql);
        while (matcher.find()) {
            String tableName = matcher.group(1);
            if (tableNames.contains(tableName)) continue;
            tableNames.add(tableName);
        }
        return tableNames;
    }

    private String extractSqlBuilderClassName(TenantSql.Find annotation) {
        try {
            Class<TenantSql.SqlBuilder<?>> builderClass = annotation.sqlBuilder();
            if (builderClass.getName().equals("io.resys.thena.api.annotations.TenantSql$DefaultSqlBuilder")) {
                return null;
            }
            return builderClass.getName();
        }
        catch (MirroredTypeException e) {
            String typeMirror = e.getTypeMirror().toString();
            if (typeMirror.equals("io.resys.thena.api.annotations.TenantSql.DefaultSqlBuilder")) {
                return null;
            }
            return typeMirror;
        }
    }

    private String extractSqlBuilderClassName(TenantSql.FindAll annotation) {
        try {
            Class<TenantSql.SqlBuilder<?>> builderClass = annotation.sqlBuilder();
            if (builderClass.getName().equals("io.resys.thena.api.annotations.TenantSql$DefaultSqlBuilder")) {
                return null;
            }
            return builderClass.getName();
        }
        catch (MirroredTypeException e) {
            String typeMirror = e.getTypeMirror().toString();
            if (typeMirror.equals("io.resys.thena.api.annotations.TenantSql.DefaultSqlBuilder")) {
                return null;
            }
            return typeMirror;
        }
    }
}

