/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.thena.datasource.ImmutableSql;
import io.resys.thena.datasource.ImmutableSqlTuple;
import io.resys.thena.datasource.ImmutableSqlTupleList;
import io.resys.thena.datasource.ThenaSqlClient;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.resys.thena.processor.model.Metamodel;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.TableCodeGenerator;
import io.resys.thena.processor.support.NamingUtils;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import lombok.Generated;

public class Gen_Table_SqlImplementation
implements TableCodeGenerator {
    private final Metamodel metamodel;

    @Override
    public JavaFile generate(TableMetamodel model, RegistryMetamodel registry) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(model.getImplClassName()).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addSuperinterface(ClassName.get(model.getPackageName(), model.getInterfaceName(), new String[0])).addAnnotation(ClassName.get("lombok.extern.slf4j", "Slf4j", new String[0])).addAnnotation(ClassName.get("lombok", "Value", new String[0])).addAnnotation(ClassName.get("lombok", "AllArgsConstructor", new String[0]));
        this.addFields(classBuilder, registry);
        this.addConstructor(classBuilder, registry);
        for (TableMetamodel.SqlMethod method : model.getSqlMethods()) {
            classBuilder.addMethod(this.generateMethod(method, model));
        }
        return JavaFile.builder(model.getPackageName() + ".spi", classBuilder.build()).indent("  ").build();
    }

    private void addFields(TypeSpec.Builder classBuilder, RegistryMetamodel registry) {
        classBuilder.addField(FieldSpec.builder(ClassName.bestGuess(registry.getTableClassName()), "tables", new Modifier[0]).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(ThenaSqlDataSource.class), "dataSource", new Modifier[0]).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(ThenaSqlDataSourceErrorHandler.class), "errorHandler", new Modifier[0]).build());
    }

    private void addConstructor(TypeSpec.Builder classBuilder, RegistryMetamodel registry) {
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ClassName.bestGuess(registry.getTableClassName()), "tables", new Modifier[0]).addParameter(ClassName.get(ThenaSqlDataSource.class), "dataSource", new Modifier[0]).addStatement("this.tables = tables", new Object[0]).addStatement("this.dataSource = dataSource", new Object[0]).addStatement("this.errorHandler = dataSource.getErrorHandler()", new Object[0]).build();
        classBuilder.addMethod(constructor);
    }

    private MethodSpec generateMethod(TableMetamodel.SqlMethod method, TableMetamodel model) {
        return switch (method.getType()) {
            default -> throw new MatchException(null, null);
            case TableMetamodel.SqlMethodType.SELECT -> this.generateQueryMethod(method, model);
            case TableMetamodel.SqlMethodType.SELECT_ALL -> this.generateQueryMethod(method, model);
            case TableMetamodel.SqlMethodType.INSERT -> this.generateSingleInsertMethod(method, model);
            case TableMetamodel.SqlMethodType.INSERT_ALL -> this.generateBatchMethod(method, model);
            case TableMetamodel.SqlMethodType.UPDATE -> this.generateSingleUpdateMethod(method, model);
            case TableMetamodel.SqlMethodType.UPDATE_ALL -> this.generateBatchMethod(method, model);
            case TableMetamodel.SqlMethodType.DELETE -> this.generateSingleDeleteMethod(method, model);
            case TableMetamodel.SqlMethodType.DELETE_ALL -> this.generateBatchMethod(method, model);
            case TableMetamodel.SqlMethodType.CREATE_TABLE, TableMetamodel.SqlMethodType.CREATE_CONSTRAINTS, TableMetamodel.SqlMethodType.DROP_TABLE -> this.generateLifecycleMethod(method, model);
        };
    }

    private MethodSpec generateLifecycleMethod(TableMetamodel.SqlMethod method, TableMetamodel model) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder(method.getMethodName()).addModifiers(Modifier.PUBLIC).returns(ClassName.get(ThenaSqlClient.Sql.class));
        String resolvedSql = this.resolveSqlPlaceholders(method.getSqlTemplate(), method.getTableNames());
        builder.addStatement("return $T.builder().value($L).build()", ClassName.get(ImmutableSql.class), resolvedSql);
        return builder.build();
    }

    private MethodSpec generateQueryMethod(TableMetamodel.SqlMethod method, TableMetamodel model) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder(method.getMethodName()).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC);
        for (TableMetamodel.MethodParameter param : method.getParameters()) {
            builder.addParameter(param.getType(), param.getName(), new Modifier[0]);
        }
        if (method.getWrapperType() != null) {
            builder.returns(ParameterizedTypeName.get((ClassName)method.getWrapperType(), method.getReturnType()));
            this.generateExecutionBody(builder, method, model);
        } else {
            builder.returns(this.getDirectReturnType(method.getPropsType()));
            this.generateSqlReturnBody(builder, method, model);
        }
        return builder.build();
    }

    private MethodSpec generateSingleInsertMethod(TableMetamodel.SqlMethod method, TableMetamodel model) {
        return this.generateSinglePropsMethod(method, model);
    }

    private MethodSpec generateSingleUpdateMethod(TableMetamodel.SqlMethod method, TableMetamodel model) {
        return this.generateSinglePropsMethod(method, model);
    }

    private MethodSpec generateSingleDeleteMethod(TableMetamodel.SqlMethod method, TableMetamodel model) {
        return this.generateSinglePropsMethod(method, model);
    }

    private MethodSpec generateSinglePropsMethod(TableMetamodel.SqlMethod method, TableMetamodel model) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder(method.getMethodName()).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ClassName.get(ThenaSqlClient.SqlTuple.class));
        for (TableMetamodel.MethodParameter param : method.getParameters()) {
            builder.addParameter(param.getType(), param.getName(), new Modifier[0]);
        }
        String singleParam = method.getParameters().get(0).getName();
        String resolvedSql = this.resolveSqlPlaceholders(method.getSqlTemplate(), method.getTableNames());
        builder.addStatement("return $T.builder()\n  .value($L)\n  .props(new $T().apply($L))\n  .build()", ClassName.get(ImmutableSqlTuple.class), resolvedSql, ClassName.bestGuess(method.getMapperClassName()), singleParam);
        return builder.build();
    }

    private MethodSpec generateBatchMethod(TableMetamodel.SqlMethod method, TableMetamodel model) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder(method.getMethodName()).addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ClassName.get(ThenaSqlClient.SqlTupleList.class));
        for (TableMetamodel.MethodParameter param : method.getParameters()) {
            builder.addParameter(param.getType(), param.getName(), new Modifier[0]);
        }
        String collectionParam = method.getParameters().get(0).getName();
        String resolvedSql = this.resolveSqlPlaceholders(method.getSqlTemplate(), method.getTableNames());
        builder.addStatement("final var mapper = new $T()", ClassName.bestGuess(method.getMapperClassName()));
        builder.addStatement("return $T.builder()\n  .value($L)\n  .props($L.stream()\n    .map(mapper::apply)\n    .collect($T.toList()))\n  .build()", ClassName.get(ImmutableSqlTupleList.class), resolvedSql, collectionParam, ClassName.get("java.util.stream", "Collectors", new String[0]));
        return builder.build();
    }

    private void generateSqlReturnBody(MethodSpec.Builder builder, TableMetamodel.SqlMethod method, TableMetamodel model) {
        if (method.getSqlBuilderClassName() != null && method.getParameters().size() == 1) {
            TableMetamodel.MethodParameter param = method.getParameters().get(0);
            builder.addStatement("final var sqlBuilder = new $T()", ClassName.bestGuess(method.getSqlBuilderClassName()));
            builder.addStatement("final var baseSql = sqlBuilder.apply(dataSource.getTenant(), $L, $L)", this.resolveSqlPlaceholders(method.getSqlTemplate(), method.getTableNames()), param.getName());
            builder.addCode("\n", new Object[0]);
            builder.addStatement("var sqlValue = baseSql.getValue()", new Object[0]);
            List tablesOrderedByOrder = this.metamodel.getTables().stream().sorted((a, b) -> Integer.compare(a.getOrder(), b.getOrder())).collect(Collectors.toList());
            for (TableMetamodel table : tablesOrderedByOrder) {
                String tableName = table.getTableName();
                String getterName = NamingUtils.toCamelCaseCapitalized(tableName);
                builder.addStatement("sqlValue = sqlValue.replaceAll(\"(?i)\\\\{$L\\\\}\", tables.get$L())", tableName, getterName);
            }
            builder.addCode("\n", new Object[0]);
            builder.addStatement("return $T.builder().value(sqlValue).props(baseSql.getProps()).rowMapper(new $T()).build()", ClassName.get(ImmutableSqlTuple.class), ClassName.bestGuess(method.getMapperClassName()));
        } else {
            String resolvedSql = this.resolveSqlPlaceholders(method.getSqlTemplate(), method.getTableNames());
            if (method.getPropsType() == TableMetamodel.SqlPropsType.SQL) {
                builder.addStatement("return $T.builder().value($L).rowMapper(new $T()).build()", ClassName.get(ImmutableSql.class), resolvedSql, ClassName.bestGuess(method.getMapperClassName()));
            } else {
                String propsArgs = method.getParameters().stream().map(TableMetamodel.MethodParameter::getName).collect(Collectors.joining(", "));
                builder.addStatement("return $T.builder().value($L).props($T.of($L)).rowMapper(new $T()).build()", ClassName.get(ImmutableSqlTuple.class), resolvedSql, ClassName.get("io.vertx.mutiny.sqlclient", "Tuple", new String[0]), propsArgs, ClassName.bestGuess(method.getMapperClassName()));
            }
        }
    }

    private void generateExecutionBody(MethodSpec.Builder builder, TableMetamodel.SqlMethod method, TableMetamodel model) {
        String resolvedSql = this.resolveSqlPlaceholders(method.getSqlTemplate(), method.getTableNames());
        if (method.getPropsType() == TableMetamodel.SqlPropsType.SQL) {
            builder.addStatement("final var sql = $T.builder().value($L).build()", ClassName.get(ImmutableSql.class), resolvedSql);
        } else {
            String propsArgs = method.getParameters().stream().map(TableMetamodel.MethodParameter::getName).collect(Collectors.joining(", "));
            builder.addStatement("final var sql = $T.builder().value($L).props($T.of($L)).build()", ClassName.get(ImmutableSqlTuple.class), resolvedSql, ClassName.get("io.vertx.mutiny.sqlclient", "Tuple", new String[0]), propsArgs);
        }
        builder.beginControlFlow("if(log.isDebugEnabled())", new Object[0]).addStatement("log.debug($S, sql.getPropsDeepString(), sql.getValue())", "Query " + method.getMethodName() + " with props: {} \\r\\n{}").endControlFlow();
        builder.addCode("return dataSource.getClient().preparedQuery(sql.getValue())\n", new Object[0]).addCode("  .mapping(new $T())\n", ClassName.bestGuess(method.getMapperClassName())).addCode("  .execute(sql.getProps())\n", new Object[0]).addCode("  .onItem().transformToMulti($T::toMulti)\n", ClassName.get("io.vertx.mutiny.sqlclient", "RowSet", new String[0])).addCode("  .collect().asList()\n", new Object[0]).addStatement("  .onFailure().invoke(e -> errorHandler.deadEnd(sql.failed(e, $S)))", "Can't execute " + method.getMethodName());
    }

    private String resolveSqlPlaceholders(String sql, List<String> tableNames) {
        String normalizedSql = sql.replaceAll("\\s+", " ").trim();
        if (tableNames.isEmpty()) {
            return "\"" + normalizedSql + "\"";
        }
        StringBuilder result = new StringBuilder("\"");
        String current = normalizedSql;
        for (String tableName : tableNames) {
            String placeholder = "{" + tableName + "}";
            CharSequence[] parts = current.split(Pattern.quote(placeholder), -1);
            if (parts.length <= 1) continue;
            String getterName = NamingUtils.toCamelCaseCapitalized(tableName);
            current = String.join((CharSequence)("\" + tables.get" + getterName + "() + \""), parts);
        }
        result.append(current).append("\"");
        return result.toString();
    }

    private ClassName getDirectReturnType(TableMetamodel.SqlPropsType propsType) {
        return switch (propsType) {
            default -> throw new MatchException(null, null);
            case TableMetamodel.SqlPropsType.SQL -> ClassName.get(ThenaSqlClient.Sql.class);
            case TableMetamodel.SqlPropsType.SQL_TUPLE -> ClassName.get(ThenaSqlClient.SqlTuple.class);
            case TableMetamodel.SqlPropsType.SQL_TUPLE_LIST -> ClassName.get(ThenaSqlClient.SqlTupleList.class);
        };
    }

    @Generated
    public Gen_Table_SqlImplementation(Metamodel metamodel) {
        this.metamodel = metamodel;
    }
}

