/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import io.resys.thena.api.actions.TenantActions;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.datasource.TenantCacheImpl;
import io.resys.thena.datasource.TenantContext;
import io.resys.thena.datasource.ThenaDataSource;
import io.resys.thena.datasource.ThenaSqlDataSource;
import io.resys.thena.datasource.ThenaSqlDataSourceErrorHandler;
import io.resys.thena.datasource.ThenaSqlDataSourceImpl;
import io.resys.thena.datasource.vertx.ThenaSqlPoolVertx;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.spi.RegistryCodeGenerator;
import io.resys.thena.spi.TenantActionsImpl;
import io.resys.thena.spi.TenantDataSource;
import io.resys.thena.spi.TenantException;
import io.resys.thena.support.RepoAssert;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class Gen_Registry_DatabaseImplementation
implements RegistryCodeGenerator {
    @Override
    public JavaFile generate(RegistryMetamodel registry) {
        String className = registry.getName() + "DbImpl";
        String interfaceName = registry.getName() + "Db";
        String packageName = registry.getPackageName() + ".spi";
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC).addSuperinterface(ClassName.get(registry.getPackageName(), interfaceName, new String[0])).addAnnotation(AnnotationSpec.builder(ClassName.get("lombok", "RequiredArgsConstructor", new String[0])).build()).addAnnotation(AnnotationSpec.builder(ClassName.get("lombok.extern.slf4j", "Slf4j", new String[0])).build());
        classBuilder.addField(FieldSpec.builder(ClassName.get(ThenaSqlDataSource.class), "dataSource", Modifier.PRIVATE, Modifier.FINAL).build());
        classBuilder.addMethod(this.generateGetDataSource());
        classBuilder.addMethod(this.generateTenant(registry));
        classBuilder.addMethod(this.generateWithTenantString(registry, interfaceName));
        classBuilder.addMethod(this.generateWithTenantObject(registry, className, interfaceName));
        classBuilder.addMethod(this.generateWithTenantDefault(registry, interfaceName));
        classBuilder.addMethod(this.generateWithTransaction(registry, className, interfaceName));
        classBuilder.addMethod(this.generateQuery(registry));
        classBuilder.addMethod(this.generateBuilder(registry));
        classBuilder.addMethod(this.generateCreateIfNot(registry, interfaceName));
        classBuilder.addMethod(this.generateTenantNotFound());
        classBuilder.addMethod(this.generateStaticCreateWithParams(className));
        classBuilder.addMethod(this.generateStaticCreate());
        classBuilder.addType(this.generateBuilderClass(className));
        return JavaFile.builder(packageName, classBuilder.build()).indent("  ").build();
    }

    private MethodSpec generateGetDataSource() {
        return MethodSpec.methodBuilder("getDataSource").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ClassName.get(ThenaDataSource.class)).addStatement("return dataSource", new Object[0]).build();
    }

    private MethodSpec generateTenant(RegistryMetamodel registry) {
        return MethodSpec.methodBuilder("tenant").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ClassName.get(TenantDataSource.InternalTenantQuery.class)).addStatement("return new $T(dataSource)", ClassName.bestGuess(registry.getInternalTenantQueryClassName())).build();
    }

    private MethodSpec generateWithTenantString(RegistryMetamodel registry, String interfaceName) {
        return MethodSpec.methodBuilder("withTenant").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)String.class), "tenantId", new Modifier[0]).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.get(registry.getPackageName(), interfaceName, new String[0]))).addCode(CodeBlock.builder().add("return tenant().getByNameOrId(tenantId).onItem().transformToUni(tenant -> {\n", new Object[0]).indent().add("if(tenant == null) {\n", new Object[0]).indent().add("return tenantNotFound(tenantId);\n", new Object[0]).unindent().add("}\n", new Object[0]).add("return $T.createFrom().item(withTenant(tenant));\n", ClassName.get(Uni.class)).unindent().add("});\n", new Object[0]).build()).build();
    }

    private MethodSpec generateWithTenantObject(RegistryMetamodel registry, String className, String interfaceName) {
        return MethodSpec.methodBuilder("withTenant").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(Tenant.class), "tenant", new Modifier[0]).returns(ClassName.get(registry.getPackageName(), interfaceName, new String[0])).addStatement("return new $T(dataSource.withTenant(tenant))", ClassName.bestGuess(className)).build();
    }

    private MethodSpec generateWithTenantDefault(RegistryMetamodel registry, String interfaceName) {
        return MethodSpec.methodBuilder("withTenant").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.get(registry.getPackageName(), interfaceName, new String[0]))).addCode(CodeBlock.builder().add("if(this.dataSource.isTenantLoaded()) {\n", new Object[0]).indent().add("return $T.createFrom().item(this);\n", ClassName.get(Uni.class)).unindent().add("}\n", new Object[0]).add("return this.withTenant(this.dataSource.getTenant().getName());\n", new Object[0]).build()).build();
    }

    private MethodSpec generateWithTransaction(RegistryMetamodel registry, String className, String interfaceName) {
        TypeVariableName typeVarR = TypeVariableName.get("R");
        return MethodSpec.methodBuilder("withTransaction").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).addTypeVariable(typeVarR).addParameter(ClassName.get(TenantDataSource.TxScope.class), "scope", new Modifier[0]).addParameter(ParameterizedTypeName.get(ClassName.get(registry.getPackageName(), interfaceName, "Transaction"), typeVarR), "callback", new Modifier[0]).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), typeVarR)).addCode(CodeBlock.builder().add("return withTenant(scope.getTenantId()).onItem().transformToUni(state -> {\n", new Object[0]).indent().add("final var source = ($T) state.getDataSource();\n", ClassName.get(ThenaSqlDataSource.class)).add("return source.getPool().withTransaction(conn -> callback.apply(new $T(source.withTx(conn))));\n", ClassName.bestGuess(className)).unindent().add("});\n", new Object[0]).build()).build();
    }

    private MethodSpec generateQuery(RegistryMetamodel registry) {
        return MethodSpec.methodBuilder("query").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ClassName.get(registry.getPackageName(), registry.getName() + "DbQuery", new String[0])).addStatement("return new $T(dataSource)", ClassName.get(registry.getPackageName() + ".spi", registry.getName() + "DbQueryImpl", new String[0])).build();
    }

    private MethodSpec generateBuilder(RegistryMetamodel registry) {
        return MethodSpec.methodBuilder("builder").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(ClassName.get(registry.getPackageName(), registry.getName() + "DbBuilder", new String[0])).addStatement("return new $T(dataSource)", ClassName.get(registry.getPackageName() + ".spi", registry.getName() + "DbBuilderImpl", new String[0])).build();
    }

    private MethodSpec generateCreateIfNot(RegistryMetamodel registry, String interfaceName) {
        return MethodSpec.methodBuilder("createIfNot").addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), ClassName.get(registry.getPackageName(), interfaceName, new String[0]))).addCode(CodeBlock.builder().add("return tenant().findByNameOrId(this.dataSource.getTenant().getName())\n", new Object[0]).indent().add(".onItem().transformToUni(repo -> {\n", new Object[0]).indent().add("if(repo.isEmpty()) {\n", new Object[0]).indent().add("return new $T(this, $T.$L)\n", ClassName.get(TenantActionsImpl.class), ClassName.get(Tenant.StructureType.class), registry.getTenantType()).indent().add(".commit()\n", new Object[0]).add(".name(this.dataSource.getTenant().getName())\n", new Object[0]).add(".build().onItem().transform(commit -> {\n", new Object[0]).indent().add("if(commit.getStatus() != $T.OK) {\n", ClassName.get(TenantActions.CommitStatus.class)).indent().add("final var msg = $T.join(\",\", commit.getMessages().stream().map(e -> e.getText()).toList());\n", String.class).add("final var ex = commit.getMessages().stream().map(e -> e.getException()).filter(e -> e != null).toList();\n", new Object[0]).add("throw new $T(\"Failed to create tenant: \" + msg, ex);\n", TenantException.class).unindent().add("}\n", new Object[0]).add("return withTenant(commit.getRepo());\n", new Object[0]).unindent().add("});\n", new Object[0]).unindent().unindent().add("}\n", new Object[0]).add("return $T.createFrom().item(withTenant(repo.get()));\n", ClassName.get(Uni.class)).unindent().add("});\n", new Object[0]).unindent().build()).build();
    }

    private MethodSpec generateTenantNotFound() {
        return MethodSpec.methodBuilder("tenantNotFound").addModifiers(Modifier.PRIVATE).addTypeVariable(TypeVariableName.get("T")).addParameter((Type)((Object)String.class), "tenantId", new Modifier[0]).returns(ParameterizedTypeName.get(ClassName.get(Uni.class), TypeVariableName.get("T"))).addCode(CodeBlock.builder().add("return tenant().findAll().collect().asList().onItem().transform(tenants -> {\n", new Object[0]).indent().add("final var text = new $T()\n", StringBuilder.class).indent().add(".append(\"Tenant with name: '\").append(tenantId).append(\"' does not exist!\")\n", new Object[0]).add(".append(\" known tenants: '\").append($T.join(\",\", tenants.stream().map(r -> r.getName()).toList())).append(\"'\")\n", String.class).add(".toString();\n", new Object[0]).unindent().add("log.error(text);\n", new Object[0]).add("throw new $T(text);\n", RuntimeException.class).unindent().add("});\n", new Object[0]).build()).build();
    }

    private MethodSpec generateStaticCreateWithParams(String className) {
        return MethodSpec.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addParameter(ClassName.get(TenantContext.class), "names", new Modifier[0]).addParameter(ClassName.get("io.vertx.mutiny.sqlclient", "Pool", new String[0]), "client", new Modifier[0]).addParameter(ClassName.get(ThenaSqlDataSource.TenantCache.class), "tenantCache", new Modifier[0]).addParameter(ClassName.get(ThenaSqlDataSourceErrorHandler.class), "errorHandler", new Modifier[0]).returns(ClassName.bestGuess(className)).addStatement("final var pool = new $T(client)", ClassName.get(ThenaSqlPoolVertx.class)).addCode(CodeBlock.builder().add("final var dataSource = new $T(\n", ClassName.get(ThenaSqlDataSourceImpl.class)).indent().add("\"\", names, pool, errorHandler,\n", new Object[0]).add("$T.empty(),\n", Optional.class).add("tenantCache\n", new Object[0]).unindent().add(");\n", new Object[0]).build()).addStatement("return new $T(dataSource)", ClassName.bestGuess(className)).build();
    }

    private MethodSpec generateStaticCreate() {
        return MethodSpec.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(ClassName.bestGuess("Builder")).addStatement("return new Builder()", new Object[0]).build();
    }

    private TypeSpec generateBuilderClass(String className) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Builder").addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builder.addField(ClassName.get("io.vertx.mutiny.sqlclient", "Pool", new String[0]), "client", Modifier.PRIVATE);
        builder.addField((Type)((Object)String.class), "db", Modifier.PRIVATE);
        builder.addField(ClassName.get(ThenaSqlDataSourceErrorHandler.class), "errorHandler", Modifier.PRIVATE);
        builder.addField(ClassName.get(ThenaSqlDataSource.TenantCache.class), "tenantCache", Modifier.PRIVATE);
        builder.addMethod(MethodSpec.methodBuilder("errorHandler").addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(ThenaSqlDataSourceErrorHandler.class), "errorHandler", new Modifier[0]).returns(ClassName.bestGuess("Builder")).addStatement("this.errorHandler = errorHandler", new Object[0]).addStatement("return this", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder("tenant").addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)String.class), "db", new Modifier[0]).returns(ClassName.bestGuess("Builder")).addStatement("this.db = db", new Object[0]).addStatement("return this", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder("tenantCache").addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(ThenaSqlDataSource.TenantCache.class), "tenantCache", new Modifier[0]).returns(ClassName.bestGuess("Builder")).addStatement("this.tenantCache = tenantCache", new Object[0]).addStatement("return this", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder("client").addModifiers(Modifier.PUBLIC).addParameter(ClassName.get("io.vertx.mutiny.sqlclient", "Pool", new String[0]), "client", new Modifier[0]).returns(ClassName.bestGuess("Builder")).addStatement("this.client = client", new Object[0]).addStatement("return this", new Object[0]).build());
        builder.addMethod(MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC).returns(ClassName.bestGuess(className)).addStatement("$T.notNull(client, () -> \"client must be defined!\")", ClassName.get(RepoAssert.class)).addStatement("$T.notNull(db, () -> \"db must be defined!\")", ClassName.get(RepoAssert.class)).addStatement("$T.notNull(errorHandler, () -> \"errorHandler must be defined!\")", ClassName.get(RepoAssert.class)).addCode("\n", new Object[0]).addStatement("final var tenantCache = this.tenantCache == null ? new $T() : this.tenantCache", ClassName.get(TenantCacheImpl.class)).addStatement("final var ctx = $T.defaults(db)", ClassName.get(TenantContext.class)).addStatement("final var pool = new $T(client)", ClassName.get(ThenaSqlPoolVertx.class)).addCode("\n", new Object[0]).addCode(CodeBlock.builder().add("final var dataSource = new $T(\n", ClassName.get(ThenaSqlDataSourceImpl.class)).indent().add("db, ctx, pool, errorHandler,\n", new Object[0]).add("$T.empty(),\n", Optional.class).add("tenantCache\n", new Object[0]).unindent().add(");\n", new Object[0]).build()).addStatement("return new $T(dataSource)", ClassName.bestGuess(className)).build());
        return builder.build();
    }
}

