/*
 * Decompiled with CFR 0.152.
 */
package io.resys.thena.processor.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import io.resys.thena.api.entities.Tenant;
import io.resys.thena.processor.model.RegistryMetamodel;
import io.resys.thena.processor.model.TableMetamodel;
import io.resys.thena.processor.spi.MultiTableCodeGenerator;
import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;

public class Gen_Multi_TableNames
implements MultiTableCodeGenerator {
    @Override
    public JavaFile generate(RegistryMetamodel registry, List<TableMetamodel> tables) {
        String className = registry.getTableClassName();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder(className).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addAnnotation(ClassName.get("lombok", "Value", new String[0])).addAnnotation(ClassName.get("lombok", "Builder", new String[0]));
        classBuilder.addField(FieldSpec.builder(ClassName.bestGuess(className), "DEFAULTS", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer("defaults()", new Object[0]).build());
        classBuilder.addField(FieldSpec.builder(String.class, "prefix", new Modifier[0]).build());
        for (TableMetamodel table : tables) {
            String fieldName = this.uncapitalize(table.getTableName());
            classBuilder.addField(FieldSpec.builder(String.class, fieldName, new Modifier[0]).build());
        }
        classBuilder.addMethod(this.generateToRepoTenantMethod(registry, className));
        classBuilder.addMethod(this.generateToRepoStringMethod(registry, tables, className));
        classBuilder.addMethod(this.generateDefaultsMethod(registry, tables, className));
        return JavaFile.builder(registry.getPackageName() + ".spi", classBuilder.build()).indent("  ").build();
    }

    private MethodSpec generateToRepoTenantMethod(RegistryMetamodel registry, String className) {
        return MethodSpec.methodBuilder("toRepo").addModifiers(Modifier.PUBLIC).addParameter(ClassName.get(Tenant.class), "repo", new Modifier[0]).returns(ClassName.bestGuess(className)).addStatement("final var prefix = repo.getPrefix()", new Object[0]).addStatement("return toRepo(prefix)", new Object[0]).build();
    }

    private MethodSpec generateToRepoStringMethod(RegistryMetamodel registry, List<TableMetamodel> tables, String className) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder("toRepo").addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)String.class), "prefix", new Modifier[0]).returns(ClassName.bestGuess(className));
        builder.addCode("return $L.builder()\n", className);
        builder.addCode("  .prefix(prefix)\n", new Object[0]);
        for (TableMetamodel table : tables) {
            String tableName = table.getTableName();
            String getterName = "get" + this.capitalize(tableName);
            String builderMethod = this.uncapitalize(tableName);
            if (registry.getNonTenantTables().contains(tableName)) {
                builder.addCode("  .$L(DEFAULTS.$L())\n", builderMethod, getterName);
                continue;
            }
            builder.addCode("  .$L(prefix + DEFAULTS.$L())\n", builderMethod, getterName);
        }
        builder.addStatement("  .build()", new Object[0]);
        return builder.build();
    }

    private MethodSpec generateDefaultsMethod(RegistryMetamodel registry, List<TableMetamodel> tables, String className) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder("defaults").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(ClassName.bestGuess(className));
        builder.addCode("return $L.builder()\n", className);
        builder.addCode("  .prefix(\"\")\n", new Object[0]);
        for (TableMetamodel table : tables) {
            String tableName = table.getTableName();
            String builderMethod = this.uncapitalize(tableName);
            builder.addCode("  .$L($S)\n", builderMethod, tableName);
        }
        builder.addStatement("  .build()", new Object[0]);
        return builder.build();
    }

    private String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String[] parts = str.split("_");
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            result.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
        }
        return result.toString();
    }

    private String uncapitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String[] parts = str.split("_");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.isEmpty()) continue;
            if (i == 0) {
                result.append(part);
                continue;
            }
            result.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
        }
        return result.toString();
    }
}

